/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.time.LocalDateTime;

/**
 * 社保士兵返回的数据记录表
 *
 * @author hgw
 * @date 2024-12-12 09:40:55
 */
@Data
@TableName("t_social_friend_back_log")
@Schema(description = "社保士兵返回的数据记录表")
public class TSocialFriendBackLog {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 社保ID，逗号拼接
	 */
	@ExcelAttribute(name = "社保ID", maxLength = 2000)
	@Length(max = 2000, message = "社保ID不能超过2000个字符")
	@ExcelProperty("社保ID")
	@Schema(description = "社保ID")
	private String socialId;
	/**
	 * 请求ID
	 */
	@ExcelAttribute(name = "请求ID", maxLength = 50)
	@Length(max = 50, message = "请求ID不能超过50个字符")
	@ExcelProperty("请求ID")
	@Schema(description = "请求ID")
	private String requestId;

	/**
	 * @Description: 类型1社保增 2社保减 3医保增 4医保减 5推送的日志 6社保图片路径7医保图片路径
	 * 8社保解除劳动合同9医保解除劳动合同11社保增拉取 12社保减拉取 13医保增拉取 14医保减拉取16社保单个图片17医保单个图片 18 反馈附件下载
	 * 19:花名册附件src 20:税友异常情况记录
	 * @Author: hgw
	 * @Date: 2025/5/27 10:15
	 **/
	@ExcelAttribute(name = "类型")
	@ExcelProperty("类型")
	@Schema(description = "类型")
	private Integer type;

	/**
	 * 日志
	 */
	@ExcelAttribute(name = "日志")
	@ExcelProperty("日志")
	@Schema(description = "日志")
	private String logInfo;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime createTime;

	/**
	 * 任务状态
	 */
	@ExcelAttribute(name = "任务状态")
	@ExcelProperty("任务状态")
	@Schema(description = "任务状态")
	private String status;


}
