/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 预入职-紧急联络人
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_contact_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-紧急联络人")
public class TPreEmpContactInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;

	/**
	 * empId
	 */
	@ExcelAttribute(name = "empId", maxLength = 32)
	@Length(max = 32, message = "empId不能超过32个字符")
	@ExcelProperty("empId")
	@Schema(description = "empId")
	private String empId;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", isNotEmpty = true, errorInfo = "姓名不能为空", maxLength = 20)
	@NotBlank(message = "姓名不能为空")
	@Length(max = 20, message = "姓名不能超过20个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 32)
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 与本人关系
	 */
	@ExcelAttribute(name = "与本人关系", isNotEmpty = true, errorInfo = "与本人关系不能为空", maxLength = 50)
	@NotBlank(message = "与本人关系不能为空")
	@Length(max = 50, message = "与本人关系不能超过50个字符")
	@ExcelProperty("与本人关系")
	@Schema(description = "与本人关系")
	private String relationType;
	/**
	 * 联系地址-街道、详情
	 */
	@ExcelAttribute(name = "联系地址-街道、详情", isNotEmpty = true, errorInfo = "联系地址-街道、详情不能为空", maxLength = 100)
	@NotBlank(message = "联系地址-街道、详情不能为空")
	@Length(max = 100, message = "联系地址-街道、详情不能超过100个字符")
	@ExcelProperty("联系地址-街道、详情")
	@Schema(description = "联系地址-街道、详情")
	private String address;
	/**
	 * 联系电话
	 */
	@ExcelAttribute(name = "联系电话", isNotEmpty = true, errorInfo = "联系电话不能为空", maxLength = 20)
	@NotBlank(message = "联系电话不能为空")
	@Length(max = 20, message = "联系电话不能超过20个字符")
	@ExcelProperty("联系电话")
	@Schema(description = "联系电话")
	private String tel;

	/**
	 * 联系地址省
	 */
	@ExcelAttribute(name = "联系地址省",isArea = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("联系地址省")
	private String relationProvince;
	/**
	 * 联系地址市
	 */
	@ExcelAttribute(name = "联系地址市",isArea = true,parentField = "relationProvince")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("联系地址市")
	private String relationCity;
	/**
	 * 联系地址县
	 */
	@ExcelAttribute(name = "联系地址县",isArea = true,parentField = "relationCity")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("联系地址县")
	private String relationTown;


}
