/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.archives.entity.*;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Data
public class TGzEmpInfoSearchVo extends TGzEmpInfo {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	/**
	 * 查询使用:提交档案时间开始
	 */
	private LocalDate createTimeStart;
	/**
	 * 查询使用:提交档案时间结束
	 */
	private LocalDate createTimeEnd;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	private int limitEnd;

	/**
	 * 紧急联系人列表
	 */
	private List<TGzEmpContactInfo> emergContactList;

	/**
	 * 教育经历列表
	 */
	private List<TGzEmpEducation> eduExpList;

	/**
	 * 家庭成员列表
	 */
	private List<TGzEmpFamily> familyList;

	/**
	 * 工作经历列表
	 */
	private List<TGzEmpWork> workExpList;

	/**
	 * 技能证书列表
	 */
	private List<TGzEmpSkill> skillList;

	/**
	 * 附件列表
	 */
	private List<TAttaInfo> attaList;

}
