/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 导出-瓜子offer信息接收表
 *
 * @author hgw
 * @date 2025-6-17 09:38:47
 */
@Data
@ColumnWidth(15)
public class TGzOfferInfoExportDetailVo implements Serializable {

	@ExcelProperty("流程ID")
	private String bizId;

	@ExcelProperty("人员类别编码")
	private String empType;

	@ExcelProperty("人员类别名称")
	private String empTypeDescr;

	/**
	 * 外签类型：A： 洼地外签/ B：属地外签
	 */
	@ExcelAttribute(name = "外签类型", isDataId = true, dataType = ExcelAttributeConstants.GZ_OUT_SGIN_TYPE)
	@ExcelProperty("外签类型")
	private String outSginType;

	/**
	 * 合同公司主体：公司信息表
	 */
	@ExcelProperty("合同公司主体")
	private String comраnу;

	@ExcelProperty("姓名")
	private String name;
	@ExcelProperty("姓名拼音")
	private String nameAc;
	@ExcelProperty("姓氏拼音")
	private String lastNameAc;
	@ExcelProperty("名字拼音")
	private String firstNameAc;

	@ExcelProperty("国籍编码")
	private String country;
	@ExcelProperty("国籍描述")
	private String countryDescr;
	@ExcelProperty("证件类型编码")
	private String nationalIdType;
	@ExcelProperty("证件类型描述")
	private String nationalIdTypeDescr;
	@ExcelProperty("证件号码")
	private String nationalId;

	@ExcelAttribute(name = "性别", isDataId = true, dataType = ExcelAttributeConstants.GZ_SEX)
	@ExcelProperty("性别")
	private String sex;
	@ExcelProperty("个人手机号")
	private String phone;
	@ExcelProperty("个人邮箱")
	private String email;
	@ExcelProperty("直接上级姓名")
	private String supervisorName;
	@ExcelProperty("职务描述")
	private String jobcodeDescr;
	@ExcelProperty("工作地点")
	private String workLocation;
	@ExcelProperty("工作地点描述")
	private String workLocationDescr;
	@ExcelProperty("预计入职日期")
	private String expEntryDate;
	@ExcelProperty("部门名称")
	private String deptName;
	/**
	 * 基本工资,两位小数
	 */
	@ExcelProperty("基本工资")
	private BigDecimal basePay;
	/**
	 * 绩效工资,两位小数
	 */
	@ExcelProperty("绩效工资")
	private BigDecimal perfomPay;
	@ExcelProperty("年终奖月数")
	private Integer yearBonusMonth;
	@ExcelProperty("社保缴纳地编码")
	private String socialInsuranceLocation;
	@ExcelProperty("社保缴纳地")
	private String socialInsuranceLocationDescr;
	@ExcelProperty("社保基数")
	private BigDecimal socialInsuranceBase;
	@ExcelProperty("公积金基数")
	private BigDecimal houseAccFundBaseMax;
	/**
	 * 是否转正后缴纳公积金(Y:是 N:否)
	 */
	@ExcelAttribute(name = "是否转正后缴纳公积金", isDataId = true, readConverterExp = "Y=是,N=否")
	@ExcelProperty("是否转正后缴纳公积金")
	private String beRegularEmpPay;
	@ExcelProperty("申请人邮箱")
	private String applyUserEmail;
	@ExcelProperty("接收瓜子Offer时间")
	private String createTime;
	@ExcelAttribute(name = "Offer短信通知状态", isDataId = true, readConverterExp = "0=已发送,1=未发送")
	@ExcelProperty("Offer短信通知状态")
	private String offerSendStatus;
	@ExcelAttribute(name = "Offer短信通知状态", isDataId = true, readConverterExp = "3=待发送Offer,4=待接受Offer,5=拒绝Offer,7=接受offer,9=候选人填写信息,10=取消offer,12=候选人信息审核,13=待签署,8=合同审核通过,99=已归档,98=信息待收集,97=候选人审核通过")
	@ExcelProperty("Offer状态")
	private String offerStatus;

}
