/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;

/**
 * 瓜子offer信息接收表——导出查询vo，主要加limit参数
 *
 * @author hgw
 * @date 2025-6-17 10:00:43
 */
@Data
public class TGzOfferInfoExportSearchVo extends TGzOfferInfo {

	private LocalDate createTimeStart;
	private LocalDate createTimeEnd;

	@TableField(exist = false)
	@Schema(description = "id集合")
	private String[] idList;

	@TableField(exist = false)
	@Schema(description = "查询起")
	private int limitStart;

	@TableField(exist = false)
	@Schema(description = "查询止")
	private int limitEnd;

}
