/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpFamily;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzEmpFamilyService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpFamilySearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 瓜子家庭成员
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzempfamily")
@Tag(name = "瓜子家庭成员管理")
public class TGzEmpFamilyController {

	private final TGzEmpFamilyService tGzEmpFamilyService;


	/**
	 * 简单分页查询
	 *
	 * @param page         分页对象
	 * @param tGzEmpFamily 瓜子家庭成员
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TGzEmpFamily>> getTGzEmpFamilyPage(Page<TGzEmpFamily> page, TGzEmpFamilySearchVo tGzEmpFamily) {
		return new R<>(tGzEmpFamilyService.getTGzEmpFamilyPage(page, tGzEmpFamily));
	}

	/**
	 * 不分页查询
	 *
	 * @param tGzEmpFamily 瓜子家庭成员
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<TGzEmpFamily>> getTGzEmpFamilyNoPage(@RequestBody TGzEmpFamilySearchVo tGzEmpFamily) {
		return R.ok(tGzEmpFamilyService.noPageDiy(tGzEmpFamily));
	}

	/**
	 * 通过id查询瓜子家庭成员
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzempfamily_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempfamily_get')")
	public R<TGzEmpFamily> getById(@PathVariable("id") String id) {
		return R.ok(tGzEmpFamilyService.getById(id));
	}

	/**
	 * 新增瓜子家庭成员
	 *
	 * @param tGzEmpFamily 瓜子家庭成员
	 * @return R
	 */
	@Operation(summary = "新增瓜子家庭成员", description = "新增瓜子家庭成员：hasPermission('archives_tgzempfamily_add')")
	@SysLog("新增瓜子家庭成员")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('archives_tgzempfamily_add')")
	public R<Boolean> save(@RequestBody TGzEmpFamily tGzEmpFamily) {
		return R.ok(tGzEmpFamilyService.save(tGzEmpFamily));
	}

	/**
	 * 修改瓜子家庭成员
	 *
	 * @param tGzEmpFamily 瓜子家庭成员
	 * @return R
	 */
	@Operation(summary = "修改瓜子家庭成员", description = "修改瓜子家庭成员：hasPermission('archives_tgzempfamily_edit')")
	@SysLog("修改瓜子家庭成员")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('archives_tgzempfamily_edit')")
	public R<Boolean> updateById(@RequestBody TGzEmpFamily tGzEmpFamily) {
		return R.ok(tGzEmpFamilyService.updateById(tGzEmpFamily));
	}

	/**
	 * 通过id删除瓜子家庭成员
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除瓜子家庭成员", description = "通过id删除瓜子家庭成员：hasPermission('archives_tgzempfamily_del')")
	@SysLog("通过id删除瓜子家庭成员")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tgzempfamily_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tGzEmpFamilyService.removeById(id));
	}

}
