/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractAttachInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeLog;
import com.yifu.cloud.plus.v1.yifu.archives.vo.UpProjectSocialFundVo;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

/**
 * 档案变更日志表
 *
 * @author hgw
 * @date 2022-06-20 09:55:06
 */
public interface TEmployeeLogService extends IService<TEmployeeLog> {

	/**
	 * 生成修改记录
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 * @param type 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新
	 * @param empId 档案id
	 * @param projectId 项目id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	<T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo);

	/**
	 * 生成修改记录
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 * @param type 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新
	 * @param empId 档案id
	 * @param projectId 项目id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	<T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo,String userId,String userName);

	/**
	 * 生成修改记录
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 * @param type 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新 4入职确认信息修改
	 * @param empId 档案id
	 * @param projectId 项目id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	<T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo, YifuUser user);

	/**
	 * 生成修改记录
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 * @param type 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新
	 * @param empId 档案id
	 * @param projectId 项目id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	<T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo, UpProjectSocialFundVo vo);

	/**
	 * 生成修改记录
	 * @Author pwang
	 * @Date 2022-06-22 11:32
	 * @param type 类型：0人员档案；1项目档案；2人员和项目档案；3员工合同更新
	 * @param empId 档案id
	 * @param projectId 项目id
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	<T> TEmployeeLog saveModificationRecord(Integer type, String empId, String projectId, T oldInfo, T newInfo, FddContractAttachInfo fddContractAttachInfo);
}
