/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.LGuaziOfferRecord;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.LGuaziOfferRecordMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.LGuaziOfferRecordService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

/**
 * 瓜子offer操作日志
 *
 * @author chenyx
 * @date 2025-06-11 15:59:04
 */
@Log4j2
@Service
@RequiredArgsConstructor
public class LGuaziOfferRecordServiceImpl extends ServiceImpl<LGuaziOfferRecordMapper, LGuaziOfferRecord> implements LGuaziOfferRecordService {
    /**
     * 瓜子offer操作日志简单分页查询
     * @param lGuaziOfferRecord 瓜子offer操作日志
     * @return
     */
    @Override
    public IPage<LGuaziOfferRecord> getLGuaziOfferRecordPage(Page<LGuaziOfferRecord> page, LGuaziOfferRecord lGuaziOfferRecord){
        return baseMapper.getLGuaziOfferRecordPage(page,lGuaziOfferRecord);
    }
}
