package com.yifu.cloud.plus.v1.ekp.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

/**
 * @auther huyc
 * @date 2024/5/24
 * 聚富通基本配置
 */
@RefreshScope
@ConfigurationProperties(prefix = "icbcissue")
@Data
public class IcbcIssueConfigProperties {

	/**
	 * @Description: 聚富通分配的接入id
	 **/
	private String appId;
	/**
	 * @Description: 聚富通分配的应用方私钥
	 **/
	private String appPrivateKey;

	/**
	 * @Description: 网关公钥
	 **/
	private String apigwPublicKey;

	/**
	 * @Description: 企业编号
	 **/
	private String companyNo;

	/**
	 * @Description: 应用方加密串
	 **/
	private String aesKey;

	private String caSm;

	private String caSmIcbc;

}
