package com.yifu.cloud.plus.v1.ekp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.ekp.entity.EkpFundInfo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialSumInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 社保明细表
 *
 * @author huyc
 * @date 2024-02-29 11:21:56
 */
@Mapper
public interface EkpFundInfoMapper extends BaseMapper<EkpFundInfo> {

	/**
	 * 获取所有项目信息
	 * @param
	 * @return
	 */
	List<EkpDeptInfoVo> getAllEkpDeptInfo();

	/**
	 * 根据身份证和生成月份获取费用合计
	 * @param
	 * @return
	 */
	EkpSocialSumInfoVo getCostSumInfo(@Param("card") String empIdCard, @Param("month") String createMonth);

	/**
	 * 查询公积金id是否存在
	 * @param
	 * @return
	 */
	long getFundCount(@Param("fundId") String fundId);
}
