package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author licancan
 * @description 商险操作（加审批意见）请求参数
 * @date 2022-08-22 13:58:58
 */
@Data
@Schema(description = "商险操作（加审批意见）请求参数")
public class InsuranceHandleParam implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 商险明细id
	 */
	@Schema(description = "商险明细id")
	@NotBlank(message = "商险明细id不能为空")
	private String id;

	/**
	 * 审批意见
	 */
	@Schema(description = "审批意见")
	private String remark;
}
