package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 流程节点配置表（规则配置）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_config")
@Schema(description = "流程节点配置表（规则配置）")
public class TNodeConfig extends Model<TNodeConfig> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;

     @NotBlank(message = "是否允许撤回（0是/1否）不能为空")
     @Length(max = 1, message = "是否允许撤回（0是/1否）不能超过1个字符")
     @Schema(description = "是否允许撤回（0是/1否）")
     private String allowWithdraw;

     @NotBlank(message = "是否允许流程回溯（0是/1否）不能为空")
     @Length(max = 1, message = "是否允许流程回溯（0是/1否）不能超过1个字符")
     @Schema(description = "是否允许流程回溯（0是/1否）")
     private String allowBacktrack;

     @NotBlank(message = "是否发起处理提醒（0是/1否；提醒会在站内和移动端提醒）不能为空")
     @Length(max = 1, message = "是否发起处理提醒（0是/1否；提醒会在站内和移动端提醒）不能超过1个字符")
     @Schema(description = "是否发起处理提醒（0是/1否；提醒会在站内和移动端提醒）")
     private String allowDealRemind;

     @NotBlank(message = "节点ID不能为空")
     @Length(max = 255, message = "节点ID不能超过255个字符")
     @Schema(description = "节点ID")
     private String nodeId;
}
