package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TConfigSalary;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandard;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryStandardMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TConfigSalaryService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardService;
import com.yifu.cloud.plus.v1.yifu.salary.util.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Date;
import java.util.List;


/**
 * @Author fxj
 * @Description 普通工资配置
 * @Date 13:32 2022/8/6
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/tconfigsalary")
@Tag(name = "薪资配置-普通工资配置")
public class TConfigSalaryController {

	private final TConfigSalaryService tConfigSalaryService;
	private final TSalaryStandardService tSalaryStandardService;
	private final TSalaryStandardMapper tSalaryStandardMapper;
	private final MenuUtil menuUtil;
	/**
	 * @param settleDepart 结算主体id
	 * @Description: 获取结算主体下的配置信息
	 * @Author: hgw
	 * @Date: 2019/9/12 17:05
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "获取结算主体下的配置列表")
	@SysLog("获取结算主体下的配置列表")
	@PostMapping("getTConfigSalaryList")
	//@PreAuthorize("@pms.hasPermission('wxhr:salary_upload')")
	public R getTConfigSalaryList(@RequestParam String settleDepart) {
		TConfigSalary configSalary = new TConfigSalary();
		configSalary.setDepartId(settleDepart);
		QueryWrapper<TConfigSalary> queryWrapperCs = new QueryWrapper<>();
		queryWrapperCs.setEntity(configSalary);
		List<TConfigSalary> configSalaryList = tConfigSalaryService.list(queryWrapperCs);
		if (configSalaryList != null && !configSalaryList.isEmpty()) {
			String nowMonth = DateUtil.addMonth(0);
			String nowYear = DateUtil.getYear(new Date());
			// 当前年 未推送或未发放的 发薪次数
			int yearCount = tSalaryStandardService.getNum(settleDepart, null,null, nowYear);
			int monthCount; // 当前月 发薪次数
			for (TConfigSalary cs : configSalaryList) {
				monthCount = tSalaryStandardService.getNum(settleDepart, cs.getId(), nowMonth, null);
				if (cs.getSalaryNum() <= monthCount) {
					cs.setNowMonthSalaryNum(monthCount);
				}
				cs.setNowYearSalaryNum(yearCount);
			}
		}
		return new R<>(configSalaryList);
	}

	/**
	 * 简单分页查询
	 *
	 * @param page          分页对象
	 * @param tConfigSalary 工资报账配置
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TConfigSalary>> getTConfigSalaryPage(Page<TConfigSalary> page, TConfigSalary tConfigSalary) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tConfigSalary);
		if (Common.isNotNull(tConfigSalary.getAuthSql()) && tConfigSalary.getAuthSql().contains(CommonConstants.A_DEPT_ID)) {
			tConfigSalary.setAuthSql(tConfigSalary.getAuthSql().replace(CommonConstants.A_DEPT_ID, "a.DEPART_ID"));
		}
		return tConfigSalaryService.getTConfigSalaryPage(page, tConfigSalary);
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TConfigSalary> getById(@PathVariable("id") String id) {
		return new R<>(tConfigSalaryService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tConfigSalary
	 * @return R
	 */
	@Operation(description = "新增(wxhr:tconfigsalary_add)")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tconfigsalary_add')")
	public R<Boolean>  save(@Valid @RequestBody TConfigSalary tConfigSalary) {
		long res  = tConfigSalaryService.count(Wrappers.<TConfigSalary>query().lambda()
				.eq(TConfigSalary::getDepartId,tConfigSalary.getDepartId())
				.eq(TConfigSalary::getName,tConfigSalary.getName()));
		if ( res > 0){
			return R.failed(SalaryConstants.CONFIG_SALARY_REPEAT);
		}
		return new R<>(tConfigSalaryService.save(tConfigSalary));
	}

	/**
	 * 修改记录
	 *
	 * @param tConfigSalary
	 * @return R
	 */
	@Operation(description = "修改(wxhr:tconfigsalary_edit)")
	@SysLog("修改工资报账配置")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tconfigsalary_edit')")
	public R<Boolean> update(@RequestBody TConfigSalary tConfigSalary) {
		long res  = tConfigSalaryService.count(Wrappers.<TConfigSalary>query().lambda()
				.eq(TConfigSalary::getDepartId,tConfigSalary.getDepartId())
				.eq(TConfigSalary::getName,tConfigSalary.getName())
				.ne(TConfigSalary::getId,tConfigSalary.getId()));
		if ( res > 0){
			return R.failed(SalaryConstants.CONFIG_SALARY_REPEAT);
		}
		return new R<>(tConfigSalaryService.updateById(tConfigSalary));
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除(wxhr:tconfigsalary_del)")
	@SysLog("删除工资报账配置")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:tconfigsalary_del')")
	public R<Boolean>  removeById(@PathVariable String id) {
		return new R<>(tConfigSalaryService.removeById(id));
	}

}
