/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsDeclarer;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsDeclarerService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TStatisticsDeclarerSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;


/**
 * 申报对象表
 *
 * @author huyc
 * @date 2022-08-11 10:56:10
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tstatisticsdeclarer" )
@Tag(name = "申报对象表管理")
public class TStatisticsDeclarerController {

    private final  TStatisticsDeclarerService tStatisticsDeclarerService;
    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tStatisticsDeclarer 申报对象表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TStatisticsDeclarer>> getTStatisticsDeclarerPage(Page<TStatisticsDeclarer> page, TStatisticsDeclarerSearchVo tStatisticsDeclarer) {
        return  new R<>(tStatisticsDeclarerService.getTStatisticsDeclarerPage(page,tStatisticsDeclarer));
    }
    /**
     * 不分页查询
     * @param tStatisticsDeclarer 申报对象表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    public R<List<TStatisticsDeclarer>> getTStatisticsDeclarerNoPage(@RequestBody TStatisticsDeclarerSearchVo tStatisticsDeclarer) {
        return R.ok(tStatisticsDeclarerService.noPageDiy(tStatisticsDeclarer));
    }

    /**
     * 通过id查询申报对象表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TStatisticsDeclarer> getById(@PathVariable("id" ) String id) {
        return R.ok(tStatisticsDeclarerService.getById(id));
    }

    /**
     * 新增申报对象表
     * @param tStatisticsDeclarer 申报对象表
     * @return R
     */
    @Operation(summary = "新增申报对象表", description = "新增申报对象表：hasPermission('salary_tstatisticsdeclarer_add')")
    @SysLog("新增申报对象表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('salary_tstatisticsdeclarer_add')" )
    public R<Boolean> save(@RequestBody TStatisticsDeclarer tStatisticsDeclarer) {
        return R.ok(tStatisticsDeclarerService.save(tStatisticsDeclarer));
    }

    /**
     * 修改申报对象表
     * @param tStatisticsDeclarer 申报对象表
     * @return R
     */
    @Operation(summary = "修改申报对象表", description = "修改申报对象表：hasPermission('salary_tstatisticsdeclarer_edit')")
    @SysLog("修改申报对象表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('salary_tstatisticsdeclarer_edit')" )
    public R<Boolean> updateById(@RequestBody TStatisticsDeclarer tStatisticsDeclarer) {
        return R.ok(tStatisticsDeclarerService.updateById(tStatisticsDeclarer));
    }

    /**
     * 通过id删除申报对象表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除申报对象表", description = "通过id删除申报对象表：hasPermission('salary_tstatisticsdeclarer_del')")
    @SysLog("通过id删除申报对象表" )
    @PostMapping("/updateFlagById" )
    @PreAuthorize("@pms.hasPermission('salary_tstatisticsdeclarer_del')" )
    public R updateFlagById(@RequestParam String id, @RequestParam String isDeclare,
							@RequestParam(required = false) String undeclareReason) {
        return tStatisticsDeclarerService.updateFlagById(id,isDeclare,undeclareReason);
    }

    /**
	 * 批量删除本期申报人员
	 *
     * @author huyc
     * @date 2022-08-11 10:56:10
	 **/
    @SneakyThrows
    @Operation(description = "批量删除本期申报人员 hasPermission('salary_tstatisticsdeclarer-batch-delete')")
    @SysLog("批量删除本期申报人员")
    @PostMapping("/importListDelete")
    @PreAuthorize("@pms.hasPermission('salary_tstatisticsdeclarer-batch-delete')")
    public R<List<ErrorMessage>> importListDelete(@RequestBody MultipartFile file) throws IOException {
        return tStatisticsDeclarerService.importDiy(file.getInputStream());
    }

	/**
	 * @param
	 * @Description: 生成申报人员
	 * @Author: huyc
	 * @Date: 2022-08-17 18:17:48
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Inner
	@Operation(description = "生成申报人员")
	@PostMapping("/inner/doStatisticsTaxDeclarer")
	public R doStatisticsTaxDeclarer() {
		return tStatisticsDeclarerService.doStatisticsTaxDeclarer();
	}

    /**
     * 申报对象表 批量导出
     * @author huyc
     * @date 2022-08-11 10:56:10
     **/
    @Operation(description = "导出申报对象表 hasPermission('salary_tstatisticsdeclarer-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('salary_tstatisticsdeclarer-export')")
    public void export(HttpServletResponse response, @RequestBody TStatisticsDeclarerSearchVo searchVo) {
            tStatisticsDeclarerService.listExport(response,searchVo);
    }
}
