/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysPayProportion;
import com.yifu.cloud.plus.v1.yifu.social.mapper.SysPayProportionMapper;
import com.yifu.cloud.plus.v1.yifu.social.service.SysPayProportionService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 公积金政策对应的缴费比例表
 *
 * @author hgw
 * @date 2022-07-11 18:21:23
 */
@Service
public class SysPayProportionServiceImpl extends ServiceImpl<SysPayProportionMapper, SysPayProportion> implements SysPayProportionService {
	/**
	 * 公积金政策对应的缴费比例表简单分页查询
	 *
	 * @param sysPayProportion 公积金政策对应的缴费比例表
	 * @return
	 */
	@Override
	public IPage<SysPayProportion> getSysPayProportionPage(Page<SysPayProportion> page, SysPayProportion sysPayProportion) {
		return baseMapper.getSysPayProportionPage(page, sysPayProportion);
	}

	@Override
	public List<SysPayProportion> getSysPayProportionByBaseId(String sysBaseSetId) {
		return baseMapper.selectByPrimaryId(sysBaseSetId);
	}
}
