/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.admin.controller;


import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysUserDeptPermission;
import com.yifu.cloud.plus.v1.yifu.admin.service.SysUserDeptPermissionService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.UserPermissionVo;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目下用户部门及权限
 *
 * @author chenyuxi
 * @since 1.9.7
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/userDeptPermission")
@Tag(name = "项目下用户部门及权限")
public class UserDeptPermissionController {

	private final SysUserDeptPermissionService sysUserDeptPermissionService;

	/**
	 * 客户服务平台——获取项目下用户的部门，数据权限配置信息
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	@GetMapping("/info")
	public R<SysUserDeptPermission> getInfo(SysUserDeptPermission sysUserDeptPermission) {
		if(Common.isEmpty(sysUserDeptPermission.getProjectNo())){
			return R.failed("项目编码不能为空");
		}
		if(Common.isEmpty(sysUserDeptPermission.getUserId())){
			return R.failed("用户ID不能为空");
		}
		return R.ok(sysUserDeptPermissionService.getInfo(sysUserDeptPermission.getProjectNo(),sysUserDeptPermission.getUserId()));
	}

	/**
	 * 客户服务平台——用户权限控制
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	@SysLog("客户服务平台——用户权限控制")
	@PostMapping("/permission")
	public R<String> saveUserPermission(@RequestBody SysUserDeptPermission sysUserDeptPermission) {
		if(Common.isEmpty(sysUserDeptPermission.getProjectNo())){
			return R.failed("项目编码不能为空");
		}
		if(Common.isEmpty(sysUserDeptPermission.getUserId())){
			return R.failed("用户ID不能为空");
		}
		if (Common.isEmpty(sysUserDeptPermission.getPermissionsType())){
			return R.failed("数据权限不能为空");
		}
		if (CommonConstants.THREE_STRING.equals(sysUserDeptPermission.getPermissionsType())
				&& Common.isEmpty(sysUserDeptPermission.getAppointDeptScope())
		){
			return R.failed("指定部门时，部门范围不能为空");
		}
		return sysUserDeptPermissionService.saveUserPermission(sysUserDeptPermission);
	}

	/**
	 * 客户服务平台——绑定项目
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	@SysLog("客户服务平台——绑定项目")
	@PostMapping("/relation")
	public R<String> relationUser(@RequestBody SysUserDeptPermission sysUserDeptPermission) {
		if(Common.isEmpty(sysUserDeptPermission.getProjectNo())){
			return R.failed("项目编码不能为空");
		}
		if(Common.isEmpty(sysUserDeptPermission.getProjectName())){
			return R.failed("项目名称不能为空");
		}
		if(Common.isEmpty(sysUserDeptPermission.getUserId())){
			return R.failed("用户ID不能为空");
		}
		if (Common.isEmpty(sysUserDeptPermission.getDeptId())){
			return R.failed("部门ID不能为空");
		}
		if (Common.isEmpty(sysUserDeptPermission.getProjectId())){
			return R.failed("项目ID不能为空");
		}
		return sysUserDeptPermissionService.relationUser(sysUserDeptPermission);
	}

	/**
	 * 客户服务平台——获取指定项目下用户的数据权限
	 * @param sysUserDeptPermission 实体
	 * @return success/false
	 */
	@GetMapping("/permissionByProject")
	public R<UserPermissionVo> getUserPermissionByProject(SysUserDeptPermission sysUserDeptPermission) {
		if(Common.isEmpty(sysUserDeptPermission.getProjectNo())){
			return R.failed("项目编码不能为空");
		}
		YifuUser user = SecurityUtils.getUser();
		if (user == null || Common.isEmpty(user.getId())) {
			return R.failed(CommonConstants.PLEASE_LOG_IN);
		}
		List<UserPermissionVo> cspPermList = user.getCspPermMap();
		if(Common.isEmpty(cspPermList)){
			return R.failed("获取用户权限失败！");
		}
		// 获取用户在当前项目下的权限
		UserPermissionVo authority = null;
		for (UserPermissionVo userPermissionVo : cspPermList) {
			if(sysUserDeptPermission.getProjectNo().equals(userPermissionVo.getProjectNo())){
				authority = userPermissionVo;
			}
		}
		if(Common.isEmpty(authority)){
			return R.failed("获取用户在当前项目下的权限失败！");
		}
		return R.ok(authority);
	}

}
