/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;
import java.util.Map;

/**
 * 区域
 *
 * @author hgw
 * @date 2022-6-22 19:35:06
 */
public interface SysAreaService extends IService<SysArea> {


	/**
	 * @Description: 获取所有区域数据：用做导出：<id,name>
	 * @Author: hgw
	 * @Date: 2022/6/22 18:04
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.String, java.util.Map < java.lang.String, java.lang.String>>>
	 **/
	R<Map<String, String>> getAreaToId();

	/**
	 * @Description: 获取所有区域数据：用做导入：<name,id>
	 * @Author: hgw
	 * @Date: 2022/6/22 18:04
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.Map < java.lang.String, java.util.Map < java.lang.String, java.lang.String>>>
	 **/
	R<Map<String, String>> getAreaToName();

	List<SysArea> getAllArea();

	Map<Integer,SysArea> getSysAreaMap();

	List<AreaVo> getAreaTree();
}
