/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddReqLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddReqLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 法大大日志记录表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/fddreqlog" )
@Tag(name = "法大大日志记录表管理")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class FddReqLogController {

	private final FddReqLogService fddReqLogService;

	/**
	 * 分页查询
	 * @param page 分页对象
	 * @param fddReqLog 法大大日志记录表
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page" )
	public R getFddReqLogPage(Page page, FddReqLog fddReqLog) {
		return R.ok(fddReqLogService.getFddReqLogPage(page, fddReqLog));
	}

	/**
	 * 通过id查询法大大日志记录表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_fddreqlog_get')")
	@GetMapping("/{id}" )
	public R getById(@PathVariable("id" ) String id) {
		return R.ok(fddReqLogService.getById(id));
	}

	/**
	 * 新增法大大日志记录表
	 * @param fddReqLog 法大大日志记录表
	 * @return R
	 */
	@Operation(summary = "新增法大大日志记录表", description = "新增法大大日志记录表：hasPermission('demo_fddreqlog_add')")
	@SysLog("新增法大大日志记录表" )
	@PostMapping
	@PreAuthorize("@pms.hasPermission('demo_fddreqlog_add')" )
	public R save(@RequestBody FddReqLog fddReqLog) {
		return R.ok(fddReqLogService.save(fddReqLog));
	}

	/**
	 * 修改法大大日志记录表
	 * @param fddReqLog 法大大日志记录表
	 * @return R
	 */
	@Operation(summary = "修改法大大日志记录表", description = "修改法大大日志记录表：hasPermission('demo_fddreqlog_edit')")
	@SysLog("修改法大大日志记录表" )
	@PutMapping
	@PreAuthorize("@pms.hasPermission('demo_fddreqlog_edit')" )
	public R updateById(@RequestBody FddReqLog fddReqLog) {
		return R.ok(fddReqLogService.updateById(fddReqLog));
	}

	/**
	 * 通过id删除法大大日志记录表
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除法大大日志记录表", description = "通过id删除法大大日志记录表：hasPermission('demo_fddreqlog_del')")
	@SysLog("通过id删除法大大日志记录表" )
	@DeleteMapping("/{id}" )
	@PreAuthorize("@pms.hasPermission('demo_fddreqlog_del')" )
	public R removeById(@PathVariable String id) {
		return R.ok(fddReqLogService.removeById(id));
	}
}
