/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoFundRuleInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TAutoFundRuleInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoFundRuleInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoFundRuleInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 公积金购买规则主表
 *
 * @author fxj
 * @date 2025-11-06 16:26:08
 */
@Log4j2
@Service
public class TAutoFundRuleInfoServiceImpl extends ServiceImpl<TAutoFundRuleInfoMapper, TAutoFundRuleInfo> implements TAutoFundRuleInfoService {
	/**
	 * 社保购买规则主表简单分页查询
	 *
	 * @param tAutoFundRuleInfo 社保购买规则主表
	 * @return
	 */
	@Override
	public IPage<TAutoFundRuleInfo> getTAutoFundRuleInfoPage(Page<TAutoFundRuleInfo> page, TAutoFundRuleInfoSearchVo tAutoFundRuleInfo) {
		return baseMapper.getTAutoFundRuleInfoPage(page, tAutoFundRuleInfo);
	}

	@Override
	public List<TAutoFundRuleInfo> noPageDiy(TAutoFundRuleInfoSearchVo searchVo) {
		LambdaQueryWrapper<TAutoFundRuleInfo> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoFundRuleInfo::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private Long noPageCountDiy(TAutoFundRuleInfoSearchVo searchVo) {
		LambdaQueryWrapper<TAutoFundRuleInfo> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoFundRuleInfo::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TAutoFundRuleInfoSearchVo entity) {
		LambdaQueryWrapper<TAutoFundRuleInfo> wrapper = Wrappers.lambdaQuery();
		if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
			wrapper.ge(TAutoFundRuleInfo::getCreateTime, entity.getCreateTimes()[0])
					.le(TAutoFundRuleInfo::getCreateTime,
							entity.getCreateTimes()[1]);
		}
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TAutoFundRuleInfo::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
