/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoFundRuleRel;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TAutoFundRuleRelMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoFundRuleRelService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoFundRuleRelSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 公积金购买规则明细表
 *
 * @author fxj
 * @date 2025-11-06 16:26:07
 */
@Log4j2
@Service
public class TAutoFundRuleRelServiceImpl extends ServiceImpl<TAutoFundRuleRelMapper, TAutoFundRuleRel> implements TAutoFundRuleRelService {
	/**
	 * 社保购买规则明细表简单分页查询
	 *
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return
	 */
	@Override
	public IPage<TAutoFundRuleRel> getTAutoFundRuleRelPage(Page<TAutoFundRuleRel> page, TAutoFundRuleRelSearchVo tAutoFundRuleRel) {
		return baseMapper.getTAutoFundRuleRelPage(page, tAutoFundRuleRel);
	}


	@Override
	public List<TAutoFundRuleRel> noPageDiy(TAutoFundRuleRelSearchVo searchVo) {
		LambdaQueryWrapper<TAutoFundRuleRel> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoFundRuleRel::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(BaseEntity::getCreateTime);
		return baseMapper.selectList(wrapper);
	}

	private Long noPageCountDiy(TAutoFundRuleRelSearchVo searchVo) {
		LambdaQueryWrapper<TAutoFundRuleRel> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TAutoFundRuleRel::getId, idList);
		}
		return baseMapper.selectCount(wrapper);
	}

	private LambdaQueryWrapper buildQueryWrapper(TAutoFundRuleRelSearchVo entity) {
		LambdaQueryWrapper<TAutoFundRuleRel> wrapper = Wrappers.lambdaQuery();
		if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
			wrapper.ge(TAutoFundRuleRel::getCreateTime, entity.getCreateTimes()[0])
					.le(TAutoFundRuleRel::getCreateTime,
							entity.getCreateTimes()[1]);
		}
		if (Common.isNotNull(entity.getCreateName())) {
			wrapper.eq(TAutoFundRuleRel::getCreateName, entity.getCreateName());
		}
		return wrapper;
	}

}
