package com.yifu.cloud.plus.v1.business.service.vacation;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.dto.vacation.AddOrSaveVacationRuleDTO;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationRuleConfig;
import com.yifu.cloud.plus.v1.business.vo.vacation.VacationRuleConfigVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import java.time.LocalDateTime;

/**
 * @description: 假期配置 service
 * @author: huyc
 * @date: 2023/1/13
 */
public interface TVacationRuleConfigService extends IService<TVacationRuleConfig> {

    /**
     * @description: 获取年假配置规则
     * @return: com.yifu.cloud.v1.common.core.util.R<com.yifu.cloud.v1.hrobusiness.api.vo.vacation.VacationRuleConfigVO>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<VacationRuleConfigVO> getVacationRuleConfig();

    /**
     * @description:
     * @param user
     * @param dto
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> addOrSave(YifuUser user, AddOrSaveVacationRuleDTO dto);

    /**
     * @description: 根据入职时间返回年假天数
     * @param enjoinDate 入职时间
     * @return: java.lang.Integer 年假天数
	 * @author: huyc
	 * @date: 2023/1/13
     */
    Integer annualLeaveCalculationFormula(LocalDateTime enjoinDate);
}
