package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSet;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardSetDetail;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetDetailService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardSetService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 薪资工资条配置主表
 *
 * @author hgw
 * @date 2021-10-08 14:36:57
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tsalarystandardset")
@Tag(name = "薪资工资条配置主表")
public class TSalaryStandardSetController {

     private final TSalaryStandardSetService tSalaryStandardSetService;

     private final TSalaryStandardSetDetailService tSalaryStandardSetDetailService;

     /**
      * 简单分页查询
      *
      * @param page               分页对象
      * @param tSalaryStandardSet 薪资工资条配置主表
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TSalaryStandardSet>> getTSalaryStandardSetPage(Page<TSalaryStandardSet> page, TSalaryStandardSet tSalaryStandardSet) {
          return new R<>(tSalaryStandardSetService.getTSalaryStandardSetPage(page, tSalaryStandardSet));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TSalaryStandardSet> getById(@PathVariable("id") String id) {
          return new R<>(tSalaryStandardSetService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tSalaryStandardSet
      * @return R
      */
     @Operation(description = "新增或修改(tsalarystandardset_add)")
     @PostMapping("/saveOrUptateSet")
     @PreAuthorize("@pms.hasPermission('tsalarystandardset_add')")
     public R<TSalaryStandardSet> saveOrUptateSet(@RequestBody TSalaryStandardSet tSalaryStandardSet) {
          return tSalaryStandardSetService.saveOrUpdateSet(tSalaryStandardSet);
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除(tsalarystandardset_del)")
     @SysLog("删除薪资工资条配置主表")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('tsalarystandardset_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          tSalaryStandardSetDetailService.remove(Wrappers.<TSalaryStandardSetDetail>query().lambda().eq(TSalaryStandardSetDetail::getSetId, id));
          return new R<>(tSalaryStandardSetService.removeById(id));
     }

}
