package com.yifu.cloud.plus.v1.yifu.salary.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.salary.constants.SalaryConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryTaxConfig;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryTaxConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;


/**
 * @Author fxj
 * @Description 个税比例及速算扣除数的配置表
 * @Date 13:33 2022/8/6
 * @Param
 * @return
**/
@RestController
@AllArgsConstructor
@RequestMapping("/tsalarytaxconfig")
@Tag(name = "薪资配置-所得税配置")
public class TSalaryTaxConfigController {

	private final TSalaryTaxConfigService tSalaryTaxConfigService;

	/**
	 * @param page             分页对象
	 * @param tSalaryTaxConfig 个税比例及速算扣除数的配置表
	 * @Description: 工资个税-分页查询
	 * @Author: hgw
	 * @Date: 2019/10/15 18:06
	 * @return: com.yifu.cloud.v1.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>>
	 **/
	@Operation(description = "工资个税-分页查询")
	@GetMapping("/salaryPage")
	public R<IPage<TSalaryTaxConfig>> getTSalaryTaxConfigPageBySalary(Page<TSalaryTaxConfig> page, TSalaryTaxConfig tSalaryTaxConfig) {
		tSalaryTaxConfig.setType(SalaryConstants.SALARY_TAX_TYPE[0]);
		//根据 level 顺序排序
		List<OrderItem> orders = new ArrayList<>();
		OrderItem oi = new OrderItem();
		oi.setColumn("level");
		oi.setAsc(true);
		orders.add(oi);
		page.setOrders(orders);
		return new R<>(tSalaryTaxConfigService.getTSalaryTaxConfigPage(page, tSalaryTaxConfig));
	}

	/**
	 * @param page             分页对象
	 * @param tSalaryTaxConfig 个税比例及速算扣除数的配置表
	 * @Description: 年终奖个税-分页查询
	 * @Author: hgw
	 * @Date: 2019/10/15 18:05
	 * @return: com.yifu.cloud.v1.common.core.util.R<com.baomidou.mybatisplus.core.metadata.IPage < com.yifu.cloud.v1.hrms.api.entity.TSalaryTaxConfig>>
	 **/
	@Operation(description = "年终奖个税-分页查询")
	@GetMapping("/yearPage")
	public R<IPage<TSalaryTaxConfig>> getTSalaryTaxConfigPageByYear(Page<TSalaryTaxConfig> page, TSalaryTaxConfig tSalaryTaxConfig) {
		tSalaryTaxConfig.setType(SalaryConstants.SALARY_TAX_TYPE[1]);
		//根据 level 顺序排序
		List<OrderItem> orders = new ArrayList<>();
		OrderItem oi = new OrderItem();
		oi.setColumn("level");
		oi.setAsc(true);
		orders.add(oi);
		page.setOrders(orders);
		return new R<>(tSalaryTaxConfigService.getTSalaryTaxConfigPage(page, tSalaryTaxConfig));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "id查询")
	@GetMapping("/{id}")
	public R<TSalaryTaxConfig> getById(@PathVariable("id") String id) {
		return new R<>(tSalaryTaxConfigService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tSalaryTaxConfig
	 * @return R
	 */
	@Operation(description = "新增")
	@SysLog("新增个税比例及速算扣除数的配置表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tsalarytaxconfig_add')")
	public R save(@RequestBody TSalaryTaxConfig tSalaryTaxConfig) {
		return new R<>(tSalaryTaxConfigService.save(tSalaryTaxConfig));
	}

	/**
	 * 修改记录
	 *
	 * @param tSalaryTaxConfig
	 * @return R
	 */
	@Operation(description = "修改")
	@SysLog("修改个税比例及速算扣除数的配置表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('wxhr:tsalarytaxconfig_edit')")
	public R update(@RequestBody TSalaryTaxConfig tSalaryTaxConfig) {
		return new R<>(tSalaryTaxConfigService.updateById(tSalaryTaxConfig));
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(description = "删除")
	@SysLog("删除个税比例及速算扣除数的配置表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('wxhr:tsalarytaxconfig_del')")
	public R removeById(@PathVariable String id) {
		return new R<>(tSalaryTaxConfigService.removeById(id));
	}

}
