/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 员工合同签订规则配置表
 *
 * @author fxj
 * @date 2025-06-10 16:24:30
 */
@Data
@TableName("t_auto_contract_rule_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工合同签订规则配置表")
public class TAutoContractRuleInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 是否自动触发申请：0自动生成合同申请 1手动发起合同申请
	 */
	@ExcelAttribute(name = "是否自动触发申请", isNotEmpty = true, errorInfo = "是否自动触发申请不能为空", maxLength = 1)
	@NotBlank(message = "是否自动触发申请不能为空")
	@Length(max = 1, message = "是否自动触发申请不能超过1个字符")
	@ExcelProperty("是否自动触发申请")
	@Schema(description = "是否自动触发申请：0自动生成合同申请 1手动发起合同申请")
	private String autoFlag;
	/**
	 * 新签合同发起时间类型 0 入职日期 1入职3天后 2入职1周后 3入职2周后 4入职3周后
	 */
	@ExcelAttribute(name = "新签合同发起时间类型 ", maxLength = 1)
	@Length(max = 1, message = "新签合同发起时间类型 不能超过1个字符")
	@ExcelProperty("新签合同发起时间类型 ")
	@Schema(description = "新签合同发起时间类型 0 入职日期 1入职3天后 2入职1周后 3入职2周后 4入职3周后")
	private String newSignType;
	/**
	 * 新签合同发起时间
	 */
	@ExcelAttribute(name = "新签合同发起时间", maxLength = 10)
	@Length(max = 10, message = "新签合同发起时间不能超过10个字符")
	@ExcelProperty("新签合同发起时间")
	@Schema(description = "新签合同发起时间")
	private String newSignDate;
	/**
	 * 确认签署时间类型 0 签订发起日
	 */
	@ExcelAttribute(name = "确认签署时间类型 ", maxLength = 1)
	@Length(max = 1, message = "确认签署时间类型 不能超过1个字符")
	@ExcelProperty("确认签署时间类型 ")
	@Schema(description = "确认签署时间类型 0 签订发起日")
	private String confirmSignType;
	/**
	 * 确认签署时间
	 */
	@ExcelAttribute(name = "确认签署时间", maxLength = 10)
	@Length(max = 10, message = "确认签署时间不能超过10个字符")
	@ExcelProperty("确认签署时间")
	@Schema(description = "确认签署时间")
	private String confirmSignDate;
	/**
	 * 续签合同发起时间类型 0 上一份合同到期前一个月
	 */
	@ExcelAttribute(name = "续签合同发起时间类型 ", maxLength = 1)
	@Length(max = 1, message = "续签合同发起时间类型 不能超过1个字符")
	@ExcelProperty("续签合同发起时间类型 ")
	@Schema(description = "续签合同发起时间类型 0 上一份合同到期前一个月")
	private String renewalDateType;
	/**
	 * 续签合同发起时间
	 */
	@ExcelAttribute(name = "续签合同发起时间", maxLength = 10)
	@Length(max = 10, message = "续签合同发起时间不能超过10个字符")
	@ExcelProperty("续签合同发起时间")
	@Schema(description = "续签合同发起时间")
	private String renewalDate;
	/**
	 * 入职确认选择  0 配置方案内选择、1 自定义 2 配置方案+自定义
	 */
	@ExcelAttribute(name = "入职确认选择", maxLength = 1)
	@Length(max = 1, message = "入职确认选择不能超过1个字符")
	@ExcelProperty("入职确认选择")
	@Schema(description = "入职确认选择  0 配置方案内选择、1 自定义 2 配置方案+自定义")
	private String confirmEmpSelect;
	/**
	 * 超时未确认是否触发签署任务(电子签) 0 自动触发 1 不触发
	 */
	@ExcelAttribute(name = "超时未确认是否触发签署任务(电子签)", maxLength = 1)
	@Length(max = 1, message = "超时未确认是否触发签署任务(电子签)不能超过1个字符")
	@ExcelProperty("超时未确认是否触发签署任务(电子签)")
	@Schema(description = "超时未确认是否触发签署任务(电子签)  0 自动触发 1 不触发")
	private String timeoutElecSign;
	/**
	 * 签署方式 0 电子签 1 线下签
	 */
	@ExcelAttribute(name = "签署方式", isNotEmpty = true, errorInfo = "签署方式不能为空", maxLength = 1)
	@NotBlank(message = "签署方式不能为空")
	@Length(max = 1, message = "签署方式不能超过1个字符")
	@ExcelProperty("签署方式")
	@Schema(description = "签署方式 0 电子签 1 线下签")
	private String signType;
	/**
	 * 项目配置主表ID
	 */
	@ExcelAttribute(name = "项目配置主表ID",errorInfo = "项目配置主表ID不能为空", maxLength = 32)
	@NotBlank(message = "项目配置主表ID不能为空")
	@Length(max = 32, message = "项目配置主表ID不能超过32个字符")
	@ExcelProperty("项目配置主表ID")
	@Schema(description = "项目配置主表ID")
	private String mainId;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码",  errorInfo = "项目编码不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 项目ID
	 */
	@ExcelAttribute(name = "项目ID",  errorInfo = "项目ID不能为空", maxLength = 32)
	@NotBlank(message = "项目ID不能为空")
	@Length(max = 32, message = "项目ID不能超过32个字符")
	@ExcelProperty("项目ID")
	@Schema(description = "项目ID")
	private String deptId;

}
