/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import javax.validation.constraints.NotBlank;

/**
 * 瓜子教育经历
 *
 * @author chenyx
 * @date 2025-06-13 15:19:04
 */
@Data
@TableName("t_gz_emp_education")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "瓜子教育经历")
public class TGzEmpEducation extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 关联瓜子档案ID
	 */
	@ExcelAttribute(name = "关联瓜子档案ID", isNotEmpty = true, errorInfo = "关联瓜子档案ID不能为空", maxLength = 32)
	@NotBlank(message = "关联瓜子档案ID不能为空")
	@Length(max = 32, message = "关联瓜子档案ID不能超过32个字符")
	@ExcelProperty("关联瓜子档案ID")
	@Schema(description = "关联瓜子档案ID")
	private String empId;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	@TableLogic
	private String delFlag;

	/**
	 * 学历
	 */
	@ExcelAttribute(name = "学历", maxLength = 2)
	@Length(max = 2, message = "学历不能超过2个字符")
	@ExcelProperty("学历")
	@Schema(description = "学历")
	private String eduQual;
	/**
	 * 学位
	 */
	@ExcelAttribute(name = "学位", maxLength = 2)
	@Length(max = 2, message = "学位不能超过2个字符")
	@ExcelProperty("学位")
	@Schema(description = "学位")
	private String eduDegree;
	/**
	 * 教育方式
	 */
	@ExcelAttribute(name = "教育方式", maxLength = 2)
	@Length(max = 2, message = "教育方式不能超过2个字符")
	@ExcelProperty("教育方式")
	@Schema(description = "教育方式")
	private String eduType;
	/**
	 * 院校名称
	 */
	@ExcelAttribute(name = "院校名称", maxLength = 48)
	@Length(max = 48, message = "院校名称不能超过48个字符")
	@ExcelProperty("院校名称")
	@Schema(description = "院校名称")
	private String school;
	/**
	 * 入学日期
	 */
	@ExcelAttribute(name = "入学日期", isDate = true)
	@ExcelProperty("入学日期")
	@Schema(description = "入学日期")
	private Date eduStartDate;
	/**
	 * 毕业日期
	 */
	@ExcelAttribute(name = "毕业日期", isDate = true)
	@ExcelProperty("毕业日期")
	@Schema(description = "毕业日期")
	private Date eduEndDate;
	/**
	 * 毕业类型
	 */
	@ExcelAttribute(name = "毕业类型", maxLength = 2)
	@Length(max = 2, message = "毕业类型不能超过2个字符")
	@ExcelProperty("毕业类型")
	@Schema(description = "毕业类型")
	private String gradutionType;
	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业", maxLength = 48)
	@Length(max = 48, message = "专业不能超过48个字符")
	@ExcelProperty("专业")
	@Schema(description = "专业")
	private String major;
	/**
	 * 是否最高学历 Y：是，N不是(系统默认为“是”)
	 */
	@ExcelAttribute(name = "是否最高学历 Y：是，N不是(系统默认为“是”)", maxLength = 1)
	@Length(max = 1, message = "是否最高学历 Y：是，N不是(系统默认为“是”)不能超过1个字符")
	@ExcelProperty("是否最高学历 Y：是，N不是(系统默认为“是”)")
	@Schema(description = "是否最高学历 Y：是，N不是(系统默认为“是”)")
	private String highEduQualFlag;
	/**
	 * 是否最高学位 Y：是，N不是
	 */
	@ExcelAttribute(name = "是否最高学位 Y：是，N不是", maxLength = 1)
	@Length(max = 1, message = "是否最高学位 Y：是，N不是不能超过1个字符")
	@ExcelProperty("是否最高学位 Y：是，N不是")
	@Schema(description = "是否最高学位 Y：是，N不是")
	private String highEduDegreeFlag;
	/**
	 * 是否第一学历 Y：是，N不是
	 */
	@ExcelAttribute(name = "是否第一学历 Y：是，N不是", maxLength = 1)
	@Length(max = 1, message = "是否第一学历 Y：是，N不是不能超过1个字符")
	@ExcelProperty("是否第一学历 Y：是，N不是")
	@Schema(description = "是否第一学历 Y：是，N不是")
	private String firstDegreeFlag;

}
