package com.yifu.cloud.plus.v1.yifu.archives.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

import java.util.Date;

/**
 * @Author: hgw
 * @Date: 2025-6-23 10:41:07
 * @Description:
 * @return: 瓜子配置
 **/
@Configuration
@Data
@Slf4j
public class GzConfig {

	@Value("${gz.appkey}")
	private String appkey;
	@Value("${gz.appsecret}")
	private String appsecret;
	@Value("${gz.tid}")
	private String tid;
	@Value("${gz.appUrl}")
	private String appUrl;

	private static final String APP_KEY = "appKey";
	private static final String TIMESTAMP = "timestamp";
	private static final String X_REQ_NONCE = "xReqNonce";
	private static final String VERSION = "version";

	public boolean getGzBankInfo(RestTemplate restTemplate, String sortedParams) {
		String gzBankUrl = appUrl + "/eim-hr-induction/api/hr/induction/open/base/bank-branch?"+ sortedParams;
		// 创建请求头并添加Authorization
		HttpHeaders headers = new HttpHeaders();
		headers.set("Authorization", "00000000"); // 设置Authorization头
		// 创建HttpEntity，包含headers（GET请求没有body，所以为null）
		HttpEntity<String> entity = new HttpEntity<>(null, headers);
		// 发送GET请求
		String result = restTemplate.exchange(gzBankUrl, HttpMethod.GET, entity, String.class).getBody();

		if (result != null && result.contains("code") && result.contains("data")) {
			JSONObject resultObject = JSON.parseObject(result);
			String code = resultObject.getString("code");
			if (Common.isNotNull(code) && "S00000".equals(code)) {
				JSONArray dataArray = (JSONArray) resultObject.get("data");
				JSONObject dataObject;
				String bankCd;
				String cnapsId;
				for (int i=0;i<dataArray.size(); i++) {
					dataObject = (JSONObject)dataArray.get(i);
					bankCd = dataObject.getString("bankCd");
					cnapsId = dataObject.getString("cnapsId");
					// TODO - 继续解析参数并存储
					System.out.println("bankCd=" + bankCd);
					System.out.println("cnapsId=" + cnapsId);
				}
				return true;
			}
		}
		return false;
	}

}
