package com.yifu.cloud.plus.v1.business.controller.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yifu.cloud.plus.v1.business.query.salary.*;
import com.yifu.cloud.plus.v1.business.service.salary.TSalaryStatisticsDepartService;
import com.yifu.cloud.plus.v1.business.service.salary.TSalaryStatisticsPersonalService;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsDepartVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsPersonalVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 薪资变动统计表 controller
 * @author: wangweiguo
 * @date: 2021-09-06
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/salaryStatistics")
@Tag(name = "薪资变动统计表相关api")
public class TSalaryStatisticsController {

    private final TSalaryStatisticsDepartService salaryStatisticsDepartService;
    
    private final TSalaryStatisticsPersonalService salaryStatisticsPersonalService;

    /**
     * 部门统计分页查询: 部门统计条件分页查询
     * @param query 部门统计查询条件
     * @return: R<IPage<TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
    */
    @Operation(summary ="部门统计分页查询: 部门统计条件分页查询")
    @GetMapping("/depart/getListByPage")
    public R<IPage<TSalaryStatisticsDepartVO>> getDepartListByPage(TSalaryStatisticsDepartPageQuery query) {
        return this.salaryStatisticsDepartService.getListByPage(query);
    }

    /**
     * 部门统计列表查询: 部门统计条件查询
     * @param query 部门统计查询条件
     * @return: R<List<TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    @Operation(summary ="部门统计列表查询: 部门统计条件查询")
    @GetMapping("/depart/getList")
    public R<List<TSalaryStatisticsDepartVO>> getDepartList(TSalaryStatisticsDepartQuery query) {
        return this.salaryStatisticsDepartService.getList(query);
    }

    /**
     * 部门合计: 条件查询部门合计
     * @param query 部门统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Operation(summary ="部门合计: 条件查询部门合计")
    @GetMapping("/depart/getSumDepartByParams")
    public R<TSalaryTotalVO> getSumDepartByParams(TSalaryStatisticsDepartQuery query) {
        query.setDepartLevel(null);
        return this.salaryStatisticsDepartService.getSumDepartByParams(query);
    }

    /**
     * 部门统计查询: 根据部门id查询当前部门合计
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
    @Operation(summary ="部门统计查询: 根据部门id查询当前部门合计")
    @GetMapping("/depart/getCurDepartSumData")
    public R<TSalaryTotalVO> getCurDepartSumData(TSalaryCurDepartQuery query) {
        return this.salaryStatisticsDepartService.getCurDepartSumData(query);
    }

    /**
     * 查询: 根据部门id查询当前部门统计数据
     * @param query 部门统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
    @Operation(summary ="部门统计查询: 根据部门id查询当前部门统计数据")
    @GetMapping("/depart/getCurDepartData")
    public R<TSalaryStatisticsDepartVO> getCurDepartData(TSalaryCurDepartQuery query) {
        return this.salaryStatisticsDepartService.getCurDepartData(query);
    }


    /**
     * 分页查询: 条件分页查询
     *
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryStatisticsDepartVO>
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    @Operation(summary ="分页查询: 条件分页查询")
    @GetMapping("/person/getListByPage")
    public R<IPage<TSalaryStatisticsPersonalVO>> getPersonListByPage(TSalaryStatisticsPersonalPageQuery query) {
        return this.salaryStatisticsPersonalService.getListByPage(query);
    }

    /**
     * 个人统计列表查询: 个人统计条件查询
     * @param query 个人统计查询条件
     * @return: R<List<TSalaryStatisticsPersonalVO>>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Operation(summary ="个人统计列表查询: 个人统计条件查询")
    @GetMapping("/person/getList")
    public R<List<TSalaryStatisticsPersonalVO>> getPersonList(TSalaryStatisticsPersonalQuery query) {
        return this.salaryStatisticsPersonalService.getList(query);
    }

    /**
     * 个人合计: 条件查询个人合计
     * @param query 个人统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Operation(summary ="个人合计: 条件查询个人合计")
    @GetMapping("/person/getSumPersonByParams")
    public R<TSalaryTotalVO> getSumPersonByParams(TSalaryStatisticsPersonalQuery query) {
        return this.salaryStatisticsPersonalService.getSumPersonalByParams(query);
    }

}

