package com.yifu.cloud.plus.v1.business.service.system;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.system.TBusAttaInfo;
import com.yifu.cloud.plus.v1.business.vo.BusFileVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * B端附件表
 *
 * @author hgw
 * @date 2021-08-12 16:38:51
 */
public interface TBusAttaInfoService extends IService<TBusAttaInfo> {

     /**
      * @param tBusAttaInfo B端附件表
      * @return list ，返回url
      */
     List<TBusAttaInfo> getBusAttaList(TBusAttaInfo tBusAttaInfo);

     /**
      * @param file
      * @param filePath
      * @param type
      * @param domain
      * @Description: 附件上传
      * @Author: hgw
      * @Date: 2021/8/19 9:16
      * @return: com.yifu.cloud.v1.common.core.util.R<com.yifu.cloud.v1.hrobusiness.api.dto.system.BusFileVo>
      **/
     R<BusFileVo> uploadFile(MultipartFile file, String filePath, Integer type, String domain) throws IOException;

     /**
      * @param id
      * @Description: 单个查询，返回url
      * @Author: hgw
      * @Date: 2021/8/20 14:38
      * @return: com.yifu.cloud.v1.hrobusiness.api.entity.system.TBusAttaInfo
      **/
     TBusAttaInfo getUrlByid(String id);

}
