package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceCompany;

import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_company(保险公司表)】的数据库操作Service
* @createDate 2022-07-18 17:19:09
*/
public interface TInsuranceCompanyService extends IService<TInsuranceCompany> {
	/**
	 * 分页查询保险公司
	 *
	 * @author zhaji
	 * @param page 分页参数
 	 * @param insuranceCompany 查询类
	 * @return {@link IPage< TInsuranceCompany>}
	 */
	IPage<TInsuranceCompany> pageDiy(Page page, TInsuranceCompany insuranceCompany);

	/**
	 * 新增保险公司
	 *
	 * @author zhaji
	 * @param insuranceCompany 新增类
	 * @return {@link R}
	 */
	R saveInsuranceCompany(TInsuranceCompany insuranceCompany);

	/**
	 * 修改保险公司
	 *
	 * @author zhaji
	 * @param insuranceCompany 修改类
	 * @return {@link R}
	 */
	R updateInsuranceCompany(TInsuranceCompany insuranceCompany);

	/**
	 * 删除保险公司信息
	 *
	 * @author zhaji
	 * @param id 保险公司id
	 * @return {@link R}
	 */
	R deleteById(String id);

	/**
	 * 查询当前保险公司列表
	 *
	 * @author zhaji
	 * @return {@link List< TInsuranceCompany>}
	 */
	List<TInsuranceCompany> getInsuranceCompanyList();
}
