package com.yifu.cloud.plus.v1.yifu.order.vo;

import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * @author licancan
 * @description 订单列表入参
 * @date 2022-08-29 09:10:02
 */
@Data
@Schema(description = "订单列表入参")
public class OrderListParam extends BaseEntity {
	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

	/**
	 * 订单开始时间
	 */
	@Schema(description = "订单开始时间")
	private String startDate;

	/**
	 * 订单结束时间
	 */
	@Schema(description = "订单结束时间")
	private String endDate;

	/**
	 * 创建人姓名（下单人）
	 */
	@Schema(description = "创建人姓名（下单人）")
	private String createName;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String deptName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 订单状态 0待办理 1办理中 2已办结
	 */
	@Schema(description = "订单状态 0待办理 1办理中 2已办结")
	private Integer orderStatus;

	/**
	 * 订单id集合
	 */
	@Schema(description = "订单id集合")
	private List<String> idList;

	/**
	 * 星级
	 */
	@Schema(description = "星级")
	private String level;

}
