/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryStandardIssueRes;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryStandardIssueResMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryStandardIssueResService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryStandardIssueResSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 薪资表与代发户表关联表
 *
 * @author hgw
 * @date 2023-01-10 11:34:27
 */
@Log4j2
@Service
public class TSalaryStandardIssueResServiceImpl extends ServiceImpl<TSalaryStandardIssueResMapper, TSalaryStandardIssueRes> implements TSalaryStandardIssueResService {

	@Override
	public List<TSalaryStandardIssueRes> noPageDiy(TSalaryStandardIssueResSearchVo searchVo) {
		LambdaQueryWrapper<TSalaryStandardIssueRes> wrapper = Wrappers.lambdaQuery();
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(TSalaryStandardIssueRes::getId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		wrapper.orderByDesc(TSalaryStandardIssueRes::getSalaryId);
		return baseMapper.selectList(wrapper);
	}

}
