/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.SociaFriendYgsAddVo;

import java.util.List;

/**
 * 税友-推送
 *
 * @author hgw
 * @date 2024-12-6 15:43:28
 */
public interface TSocialFriendPushService extends IService<TSocialInfo> {

	/**
	 * @param dispatchIdList
	 * @Description: 根据派单id，获取要派增派减的社保、医保数据，生成文件，推送到社保士兵
	 * @Author: hgw
	 * @Date: 2024/5/10 17:52
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> pushFriend(List<String> dispatchIdList);

	R<String> doExportRoster(String socialId, String type, String unitCreditCode, List<SociaFriendYgsAddVo> listVo);
}
