/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialInfo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 社保士兵-推送
 *
 * @author hgw
 * @date 2024-5-8 14:55:24
 */
public interface TSocialSoldierPushService extends IService<TSocialInfo> {

	/**
	 * @Description: 根据文件，推送到社保士兵。注意社保id别搞错了，否则塞值到社保里就塞错了
	 * @Author: hgw
	 * @Date: 2024/5/11 14:46
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> getOneAppGetModuleDetail(List<TSocialInfo> socialIdList, MultipartFile file, String type);

	/**
	 * @param dispatchIdList
	 * @Description: 根据派单id，获取要派增派减的社保、医保数据，生成文件，推送到社保士兵
	 * @Author: hgw
	 * @Date: 2024/5/10 17:52
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> pushSoldier(List<String> dispatchIdList);

	/**
	 * @param
	 * @Description: 推送当月所有提交社保局后，待社保局审核的查询任务
	 * @Author: hgw
	 * @Date: 2024/5/23 18:14
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> pushSoldierByAudit();

	/**
	 * @Description: 推送工资申报、调整（实缴使用）
	 * @Author: hgw
	 * @Date: 2024-5-29 17:47:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> pushSalaryByShenBao();
	/**
	 * @Description: 6每月6号推送实缴3张表查询
	 * @Author: hgw
	 * @Date: 2024-5-31 16:04:54
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> pushPaymentThree(String parentId, boolean isReHandle);

}
