/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.SysHouseHoldInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialfundHouseRes;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 社保公积金户权限配置表
 *
 * @author huyc
 * @date 2022-11-02 09:13:07
 */
public interface TSocialfundHouseResService extends IService<TSocialfundHouseRes> {
    /**
     * 社保公积金户权限配置表简单分页查询
     * @param tSocialfundHouseRes 社保公积金户权限配置表
     * @return
     */
    IPage<TSocialfundHouseRes> getTSocialfundHouseResPage(Page<TSocialfundHouseRes> page, TSocialfundHouseRes tSocialfundHouseRes);

    List<TSocialfundHouseRes> getexportList(TSocialfundHouseRes searchVo);

	R saveSocialAuth(TSocialfundHouseRes searchVo);

	/**
	 * @Description: 删除审核人权限
	 * @Author: hgw
	 * @Date: 2022/12/6 15:57
	 * @return: void
	 **/
	void deleteAuditUser(SysHouseHoldInfo holdInfo);

	/**
	 * @Description: 删除办理人权限
	 * @Author: hgw
	 * @Date: 2022/12/6 15:57
	 * @return: void
	 **/
	void deleteHandleUser(SysHouseHoldInfo holdInfo);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    R<List<ErrorMessage>> importDiyAll(InputStream inputStream, String type);

	/**
	 * @Description: 获取登录人的社保办理权限
	 * @Author: hgw
	 * @Date: 2025/6/16 11:31
	 * @return: java.util.Map<java.lang.String, java.lang.Integer>
	 **/
	Map<String, Integer> getMapByHandleUser(String userId);
}
