/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 字典表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@Data
@TableName("sys_auto_dict")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "字典表")
public class SysAutoDict extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private Long id;
	/**
	 * 字典编码
	 */
	@ExcelAttribute(name = "字典编码", maxLength = 100)
	@Length(max = 100, message = "字典编码不能超过100个字符")
	@ExcelProperty("字典编码")
	@Schema(description = "字典编码")
	private String type;
	/**
	 * 字典名称
	 */
	@ExcelAttribute(name = "字典名称", maxLength = 100)
	@Length(max = 100, message = "字典名称不能超过100个字符")
	@ExcelProperty("字典名称")
	@Schema(description = "字典名称")
	private String description;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Length(max = 255, message = "备注不能超过255个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 是否是系统内置
	 */
	@ExcelAttribute(name = "是否是系统内置", maxLength = 1)
	@Length(max = 1, message = "是否是系统内置不能超过1个字符")
	@ExcelProperty("是否是系统内置")
	@Schema(description = "是否是系统内置")
	private String systemFlag;
	/**
	 * 删除标记
	 */
	@ExcelAttribute(name = "删除标记", maxLength = 1)
	@Length(max = 1, message = "删除标记不能超过1个字符")
	@ExcelProperty("删除标记")
	@Schema(description = "删除标记")
	private String delFlag;
	/**
	 * 联动上级类型
	 */
	@ExcelAttribute(name = "联动上级类型", maxLength = 32)
	@Length(max = 32, message = "联动上级类型不能超过32个字符")
	@ExcelProperty("联动上级类型")
	@Schema(description = "联动上级类型")
	private String parentItemType;
	/**
	 * 客户端标识
	 */
	@ExcelAttribute(name = "客户端标识", maxLength = 32)
	@Length(max = 32, message = "客户端标识不能超过32个字符")
	@ExcelProperty("客户端标识")
	@Schema(description = "客户端标识")
	private String clientId;

}
