/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 查询Csp数据的传参vo
 * @author hgw
 * @date 2025-3-3 17:31:58
 */
@Data
public class TEmployeeProjectBelongDeptSearchCspVo {

	// 项目ID
	@Schema(description = "项目ID")
	private String deptId;

	// 身份证
	@Schema(description = "身份证")
	private String empIdCard;

	// 登记类型 1入职 2离职
	@Schema(description = "登记类型")
	private String feedbackType;

	// 项目档案入离职日期，与日志确认接收时间比较
	@Schema(description = "项目档案创建与离职时间")
	private LocalDateTime empCreateAndLeaveTime;

	// 项目档案入离职日期，与日志确认接收时间比较
	@Schema(description = "项目档案创建与离职人")
	private String empCreateAndLeaveUser;

	@Schema(description = "登录人Id")
	private String userId;

	// 项目档案入离职日期，与日志确认接收时间比较
	@Schema(description = "登录人姓名")
	private String userName;
}
