/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoEmpRuleInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoEmpRuleInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoEmpRuleInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 档案管理规则配置表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautoempruleinfo" )
@Tag(name = "档案管理规则配置表管理")
public class TAutoEmpRuleInfoController {

    private final  TAutoEmpRuleInfoService tAutoEmpRuleInfoService;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAutoEmpRuleInfo 档案管理规则配置表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAutoEmpRuleInfo>> getTAutoEmpRuleInfoPage(Page<TAutoEmpRuleInfo> page, TAutoEmpRuleInfoSearchVo tAutoEmpRuleInfo) {
        return  new R<>(tAutoEmpRuleInfoService.getTAutoEmpRuleInfoPage(page,tAutoEmpRuleInfo));
    }
    /**
     * 不分页查询
     * @param tAutoEmpRuleInfo 档案管理规则配置表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo_get')" )
    public R<List<TAutoEmpRuleInfo>> getTAutoEmpRuleInfoNoPage(@RequestBody TAutoEmpRuleInfoSearchVo tAutoEmpRuleInfo) {
        return R.ok(tAutoEmpRuleInfoService.noPageDiy(tAutoEmpRuleInfo));
    }

    /**
     * 通过id查询档案管理规则配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('demo_tautoempruleinfo_get')")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo_get')" )
    public R<TAutoEmpRuleInfo> getById(@PathVariable("id" ) String id) {
        return R.ok(tAutoEmpRuleInfoService.getById(id));
    }

    /**
     * 新增档案管理规则配置表
     * @param tAutoEmpRuleInfo 档案管理规则配置表
     * @return R
     */
    @Operation(summary = "新增档案管理规则配置表", description = "新增档案管理规则配置表：hasPermission('demo_tautoempruleinfo_add')")
    @SysLog("新增档案管理规则配置表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo_add')" )
    public R<Boolean> save(@RequestBody TAutoEmpRuleInfo tAutoEmpRuleInfo) {
        return R.ok(tAutoEmpRuleInfoService.save(tAutoEmpRuleInfo));
    }

    /**
     * 修改档案管理规则配置表
     * @param tAutoEmpRuleInfo 档案管理规则配置表
     * @return R
     */
    @Operation(summary = "修改档案管理规则配置表", description = "修改档案管理规则配置表：hasPermission('demo_tautoempruleinfo_edit')")
    @SysLog("修改档案管理规则配置表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo_edit')" )
    public R<Boolean> updateById(@RequestBody TAutoEmpRuleInfo tAutoEmpRuleInfo) {
        return R.ok(tAutoEmpRuleInfoService.updateById(tAutoEmpRuleInfo));
    }

    /**
     * 通过id删除档案管理规则配置表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除档案管理规则配置表", description = "通过id删除档案管理规则配置表：hasPermission('demo_tautoempruleinfo_del')")
    @SysLog("通过id删除档案管理规则配置表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAutoEmpRuleInfoService.removeById(id));
    }

    /**
	 * 档案管理规则配置表 批量导入
	 *
     * @author fxj
     * @date 2025-03-13 15:15:26
	 **/
    @SneakyThrows
    @Operation(description = "批量新增档案管理规则配置表 hasPermission('demo_tautoempruleinfo-batch-import')")
    @SysLog("批量新增档案管理规则配置表")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tAutoEmpRuleInfoService.importDiy(file.getInputStream());
    }

    /**
     * 档案管理规则配置表 批量导出
     * @author fxj
     * @date 2025-03-13 15:15:26
     **/
    @Operation(description = "导出档案管理规则配置表 hasPermission('demo_tautoempruleinfo-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('demo_tautoempruleinfo-export')")
    public void export(HttpServletResponse response, @RequestBody TAutoEmpRuleInfoSearchVo searchVo) {
            tAutoEmpRuleInfoService.listExport(response,searchVo);
    }
}
