/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpOtherFile;
import com.yifu.cloud.plus.v1.yifu.archives.service.TPreEmpOtherFileService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 预入职-其他附件主表
 *
 * @author hgw
 * @date 2024-07-17 14:56:34
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tpreempotherfile" )
@Tag(name = "预入职-其他附件主表管理")
public class TPreEmpOtherFileController {

    private final  TPreEmpOtherFileService tPreEmpOtherFileService;

    /**
     * 获取其他附件list-预入职
     * @param preMainId 预入职主表id
     * @return
     */
    @Operation(summary = "获取其他附件list-预入职", description = "获取其他附件list-预入职")
    @GetMapping("/getTPreEmpOtherFileListAndFile" )
    public R<List<TPreEmpOtherFile>> getTPreEmpOtherFileListAndFile(@RequestParam String preMainId) {
        return R.ok(tPreEmpOtherFileService.getTPreEmpOtherFileListAndFile(preMainId));
    }
}
