/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@Mapper
public interface TCompleteMonitorSetBaseInfoMapper extends BaseMapper<TCompleteMonitorSetBaseInfo> {

	/**
	 * @Description: 获取ids对应的所有的配置字段
	 * @Author: hgw
	 * @Date: 2025/2/26 17:25
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo>
	 **/
	List<TCompleteMonitorSetBaseInfo> getBaseInfoByIds(@Param("ids") String ids);

	// 获取类型需要完整的字段名
	String getIdByType(@Param("typeName") String typeName);
	String getIdByOne();
	List<String> getBaseFieldByIdArr(@Param("idArr") String[] idArr);

}
