package com.yifu.cloud.plus.v1.business.entity.manager;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * 客户的用户与客户的机构关系表
 *
 * @author fxj
 * @date 2021-08-11 16:54:35
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("r_user_organ")
@Schema(description = "客户的用户与客户的机构关系表")
public class RUserOrgan extends Model<RUserOrgan> {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "")
    private String id;
    /**
     * 部门ID
     */
    @NotBlank(message = "部门ID不能为空")
    @Length(max = 32, message = "部门ID不能超过32个字符")
    @ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID不能为空", maxLength = 32)
    @Schema(description = "部门ID")
    private String organId;
    /**
     * 部门CODE
     */
    @Length(max = 100, message = "部门CODE不能超过100个字符")
    @ExcelAttribute(name = "部门CODE", errorInfo = "部门CODE不能为空", maxLength = 100)
    @Schema(description = "部门CODE")
    private String organCode;
    /**
     * 部门等级
     */
    @Length(max = 2, message = "部门等级不能超过2个字符")
    @ExcelAttribute(name = "部门等级", maxLength = 2)
    @Schema(description = "部门等级")
    private String organLevel;
    /**
     * 创建人姓名
     */
    @Length(max = 32, message = "创建人姓名不能超过32个字符")
    @ExcelAttribute(name = "创建人姓名", maxLength = 32)
    @Schema(description = "创建人姓名")
    private String createUserName;
    /**
     * 创建时间
     */
    @ExcelAttribute(name = "创建时间")
    @Schema(description = "创建时间")
    private LocalDateTime createTime;
    /**
     * 用户ID
     */
    @NotBlank(message = "用户ID不能为空")
    @Length(max = 32, message = "用户ID不能超过32个字符")
    @ExcelAttribute(name = "用户ID", isNotEmpty = true, errorInfo = "用户ID不能为空", maxLength = 32)
    @Schema(description = "用户ID")
    private String userId;
    /**
     * 创建人ID
     */
    @Length(max = 32, message = "创建人ID不能超过32个字符")
    @ExcelAttribute(name = "创建人ID", maxLength = 32)
    @Schema(description = "创建人ID")
    private String createUserId;
    /**
     * 部门名称
     */
    @Length(max = 50, message = "部门名称不能超过50个字符")
    @ExcelAttribute(name = "部门名称", maxLength = 50)
    @Schema(description = "部门名称")
    private String organName;
}
