package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;


/**
 * 身份证实名校验自留库
 *
 * @author hgw
 * @date 2022-5-10 17:41:27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_check_id_card")
@Schema(description = "身份证实名校验自留库")
public class TCheckIdCard extends Model<TCheckIdCard> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 姓名
      */
     @NotBlank(message = "姓名不能为空")
     @Length(max = 20, message = "姓名不能超过20个字符")
     @Schema(description = "姓名")
     private String name;
     /**
      * 身份证
      */
     @Length(max = 18, message = "身份证不能超过18个字符")
     @Schema(description = "身份证")
     private String idCard;

     /**
      * 是否正确：1正确。0错误。
      */
     @NotNull(message = "是否正确：1正确。0错误。不能为空")
     @Schema(description = "是否正确：1正确。0错误。")
     private Integer isTrue;

     /**
      * 原因
      */
     @Length(max = 50, message = "原因不能超过50个字符")
     @Schema(description = "原因")
     private String reason;

     /**
      * 类型0：初始导入数据；1调用api保存的数据
      */
     @NotNull(message = "类型不能为空")
     @Schema(description = "类型0：初始导入数据；1调用api保存的数据")
     private Integer type;

     /**
      * 创建人
      */
     @Length(max = 32, message = "创建人不能超过32个字符")
     @Schema(description = "创建人")
     private String createUser;

     /**
      * 创建时间
      */
     @Schema(description = "创建时间")
     @NotNull(message = "创建时间不能为空")
     private LocalDateTime createTime;

}
