/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.check.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.check.entity.TCheckBankNo;
import com.yifu.cloud.plus.v1.check.vo.CheckBankNoVo;
import com.yifu.cloud.plus.v1.check.vo.CheckBatchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * 银行卡卡号 校验
 *
 * @author fxj
 * @date 2022-06-20 19:56:33
 */
public interface TCheckBankNoService extends IService<TCheckBankNo> {

	/**
	 * @Description: 代发户调用银行卡校验
	 * @Author: hgw
	 * @Date: 2023/1/13 9:39
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.check.entity.TCheckBankNo>
	 **/
	R<TCheckBankNo> checkBankNo(String name, String cardNo);

	CheckBankNoVo checkBankNoThree(String name, String cardNo, String idNum);

    CheckBankNoVo checkBankNoTwo(String name, String cardNo);

	/**
	 * @Description: C端预入职银行卡号校验
	 * @Author: hgw
	 * @Date: 2024/7/16 15:00
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> checkPreBankNo(String empName, String bankNo, String deptId);

	/**
	 * @param list
	 * @Description:批量校验卡号
	 * @Author: hgw
	 * @Date: 2023/2/9 11:19
	 * @return: com.yifu.cloud.plus.v1.check.vo.CheckBatchVo
	 **/
	CheckBatchVo checkBankNoBatch(List<TCheckBankNo> list) throws ExecutionException, InterruptedException;

	CheckBatchVo checkBankNoAndNameBatch(List<TCheckBankNo> list) throws ExecutionException, InterruptedException;

	R<List<ErrorMessage>> importDiy(InputStream inputStream);
}
