package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSocialInfo;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpSocialInfoMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpSocialInfoService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialStatusUpdateVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialSumInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.redis.RedisDistributedLock;
import com.yifu.cloud.plus.v1.yifu.common.core.util.*;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushSocialParam;
import com.yifu.cloud.plus.v1.yifu.social.entity.TPaymentSocialPush;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
//社保明细表
 *
//@author huyc
//@date 2024-02-29 11:21:56
 */
@Log4j2
@Service
public class EkpSocialInfoServiceImpl extends ServiceImpl<EkpSocialInfoMapper, EkpSocialInfo> implements EkpSocialInfoService {

	private static final int MAX_RETRY = 3; // 最大重试次数
	private static final long RETRY_DELAY_MS = 200; // 重试间隔

	/**
	//@Description: 社保明细推送至ekp
	//@Author: huyc
	//@Date: 2024-2-29
	//@return: void
	 **/
	public EkpSocialPushInfoVo pushSocialInfoToEkp(List<EkpPushSocialParam> unPushList) {

		//社保推送记录表
		List<TPaymentSocialPush> socialPushList = new ArrayList<>();
		//社保id集合 用于更新社保状态
		List<String> paymentIds = new ArrayList<>();
		//获取ekp所有项目信息
		List<EkpDeptInfoVo> deptInfoVoList = baseMapper.getAllEkpDeptInfo();
		Map<String,EkpDeptInfoVo> map = new HashMap<>();
		if (Optional.ofNullable(deptInfoVoList).isPresent()) {
			map = deptInfoVoList.stream().collect(Collectors.toMap(EkpDeptInfoVo::getDeptNo, k->k));
		}
		try {
			StringBuilder stringBuilder = new StringBuilder();
			if (!unPushList.isEmpty()) {
				Map<String, List<EkpPushSocialParam>> groups = unPushList.stream()
						.collect(Collectors.groupingBy(a -> a.getFd_3adfe8c7e4cf7a() + "_" + a.getFd_3adfe8cb96c41e()));
				Map<String, EkpDeptInfoVo> finalMap = map;
				groups.forEach((key, group) -> {
					String[] parts = key.split("_");
					String idCard = parts[0];
					String month = parts[1];
					String lockKey = "B_LOCK:" + key;
					boolean lockAcquired = false;
					int retryCount = 0;
					String requestId;
					// 重试获取锁
					while (!lockAcquired && retryCount < MAX_RETRY) {
						requestId = RedisDistributedLock.getLock(lockKey, "10");
						if (null != requestId) {
							lockAcquired = true;
							try {
								processSingleGroup(idCard, month,group, finalMap,stringBuilder,socialPushList,paymentIds);
							} catch (ParseException e) {
								e.printStackTrace();
							} finally {
								//主动释放锁
								RedisDistributedLock.unlock(key, requestId);
							}
						} else {
							retryCount++;
							try {
								Thread.sleep(RETRY_DELAY_MS); // 间隔后重试
							} catch (InterruptedException e) {
								Thread.currentThread().interrupt();
							}
						}
					}
				});
			}
			if (!socialPushList.isEmpty()) {
				//推送成功保存社保明细合并的数据对应关系
				EkpSocialPushInfoVo pushInfoVo = new EkpSocialPushInfoVo();
				pushInfoVo.setUnPushInfo(socialPushList);
				pushInfoVo.setPaymentIds(paymentIds);
				pushInfoVo.setPaymentIdSum(stringBuilder.toString());
				return pushInfoVo;
			}
		}catch (Exception e) {
			log.error("社保明细推送失败",e);
			return null;
		}
		return null;
	}

	private void processSingleGroup(String idCard, String month, List<EkpPushSocialParam> group,
									Map<String,EkpDeptInfoVo> map,StringBuilder stringBuilder,
									List<TPaymentSocialPush> socialPushList,List<String> paymentIds ) throws ParseException {
		//插入数据集合
		List<EkpSocialInfo> socialInfoList = new ArrayList<>();
		EkpDeptInfoVo deptInfo;
		EkpSocialInfo socialCount;

		//获取社保订单明细合计
		EkpSocialSumInfoVo socialSumInfo = baseMapper.getCostSumInfo(idCard, dateStringInsert(month));
		//预估单位合计
		BigDecimal ygDwSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYgDwSum());
		//实缴单位合计
		BigDecimal sjDwSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getSjDwSum());
		//实缴个人合计
		BigDecimal sjPersonSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getSjPersonSum());
		//预估合计
		BigDecimal ygSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYgSum());
		//预估个人合计
		BigDecimal ygPersonSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYgPersonSum());
		//实缴合计
		BigDecimal sjSum = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getSjSum());
		//应收
		BigDecimal ys = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getYs());
		//个人应收
		BigDecimal personYs = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getPersonYs());
		//单位应收
		BigDecimal dwYs = Common.isEmpty(socialSumInfo) ? BigDecimal.ZERO : BigDecimal.valueOf(socialSumInfo.getDwYs());

		for (EkpPushSocialParam socialParam : group) {
			//去重 防止重复推送
			socialCount = baseMapper.selectOne(Wrappers.<EkpSocialInfo>query().lambda()
					.eq(EkpSocialInfo::getFd_3b0b716e771e06, socialParam.getFd_3b0afbe1f94a08())
					.last(CommonConstants.LAST_ONE_SQL));
			if (Optional.ofNullable(socialCount).isPresent()) {
				continue;
			}
			EkpSocialInfo socialInfo = new EkpSocialInfo();
			//对象信息赋值
			copySocialProperties(socialParam, socialInfo);
			//项目信息
			deptInfo = map.get(socialInfo.getFd_3adfe8c70d3fd4());
			if (Common.isEmpty(deptInfo)) {
				continue;
			}
			socialInfo.setFd_3b16e2f436ff98_text(deptInfo.getDeptName());
			socialInfo.setFd_3b16e2f436ff98(deptInfo.getFdId());
			//实际结算月份
			if ("生成月本月数据".equals(deptInfo.getSocialType())) {
				socialInfo.setFd_3adfe8cff746bc(dateStringInsert(socialInfo.getFd_3adfe8cb96c41e()));
			} else if ("生成月上月数据".equals(deptInfo.getSocialType())) {
				socialInfo.setFd_3adfe8cff746bc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(socialInfo.getFd_3adfe8cb96c41e(), "yyyyMM"), -1), "yyyy-MM"));
			} else if ("生成月次月数据".equals(deptInfo.getSocialType())) {
				socialInfo.setFd_3adfe8cff746bc(DateUtil.dateToString(DateUtil.addMonthByDate(DateUtil.parseDate(socialInfo.getFd_3adfe8cb96c41e(), "yyyyMM"), 1), "yyyy-MM"));
			} else {
				socialInfo.setFd_3adfe8cff746bc("");
			}
			//是否全部结算
			if ("全量未结算数据".equals(deptInfo.getSocialType())) {
				socialInfo.setFd_3b1354c3add8c2(CommonConstants.IS_TRUE);
			} else {
				socialInfo.setFd_3b1354c3add8c2(CommonConstants.IS_FALSE);
			}
			//生成月份
			socialInfo.setFd_3adfe8cb96c41e(dateStringInsert(socialInfo.getFd_3adfe8cb96c41e()));
			//实缴单位合计
			BigDecimal shdw = Common.isEmpty(socialInfo.getFd_3af9f2e9208e4e()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f2e9208e4e());
			//实缴个人合计
			BigDecimal shgr = Common.isEmpty(socialInfo.getFd_3af9f303037214()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f303037214());
			//预估合计
			BigDecimal yghj = Common.isEmpty(socialInfo.getFd_3af9f2883941b4()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f2883941b4());
			//预估个人合计
			BigDecimal yggrhj = Common.isEmpty(socialInfo.getFd_3af9f285ee1e38()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f285ee1e38());
			//预估单位部分
			BigDecimal ygdwbf = Common.isEmpty(socialInfo.getFd_3adfeb4e8064a8()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3adfeb4e8064a8());
			//实缴合计
			BigDecimal sjhj = Common.isEmpty(socialInfo.getFd_3af9f3059e5b9c()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f3059e5b9c());
			//单位差异
			if ("是".equals(socialInfo.getFd_3add9de0be85e4()) && "实缴".equals(socialInfo.getFd_3add9dd7833db8())) {
				//单位差异
				//$列表.求总和$($社保订单明细*总数(实缴单位合计)$)+ $实缴单位合计$ - $列表.求总和$($社保订单明细*总数(预估单位合计)$)
				socialInfo.setFd_3adfeb53c70f72(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum, shdw),ygDwSum).doubleValue());
				//个人差异
				//$列表.求总和$($社保订单明细*总数(实缴个人合计)$)+ $实缴个人合计$ - $列表.求总和$($社保订单明细*总数(预估个人合计)$)
				socialInfo.setFd_3adfeb5413fb44(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum, shgr),ygPersonSum).doubleValue());
			}

			//Fd_3adfeb7b624f06应收；Fd_3b35a57aee1428个人应收；fd_3b35a57b6e9d0a单位应收
			if ("是".equals(deptInfo.getIsBpo())) {
				//应收
				socialInfo.setFd_3adfeb7b624f06(CommonConstants.ZERO_INTEGER.doubleValue());
				//个人应收
				socialInfo.setFd_3b35a57aee1428(CommonConstants.ZERO_INTEGER.doubleValue());
				//单位应收
				socialInfo.setFd_3b35a57b6e9d0a(CommonConstants.ZERO_INTEGER.doubleValue());
			} else {
				if ("实缴".equals(deptInfo.getSettleType())) {
					if ("预估".equals(socialInfo.getFd_3add9dd7833db8())) {
						//$列表.求总和$($社保订单明细*总数(预估合计)$)  + $预估合计$ - $列表.求总和$($社保订单明细*总数(应收)$)
						socialInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygSum, yghj),ys).doubleValue());
						//$列表.求总和$($社保订单明细*总数(预估个人合计)$)  +  $预估个人合计$ - $列表.求总和$($社保订单明细*总数(个人应收)$)
						socialInfo.setFd_3b35a57aee1428(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygPersonSum, yggrhj),personYs).doubleValue());
						//$列表.求总和$($社保订单明细*总数(预估单位合计)$)  + $预估单位合计$ - $列表.求总和$($社保订单明细*总数(单位应收)$)
						socialInfo.setFd_3b35a57b6e9d0a(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygDwSum, ygdwbf),dwYs).doubleValue());
					} else {
						if (ygSum.doubleValue() > 0) {
							//应收
							socialInfo.setFd_3adfeb7b624f06(CommonConstants.ZERO_INTEGER.doubleValue());
							//个人应收
							socialInfo.setFd_3b35a57aee1428(CommonConstants.ZERO_INTEGER.doubleValue());
							//单位应收
							socialInfo.setFd_3b35a57b6e9d0a(CommonConstants.ZERO_INTEGER.doubleValue());
						} else {
							//$列表.求总和$($社保订单明细*总数(实缴合计)$)+ $实缴合计$  - $列表.求总和$($社保订单明细*总数(应收)$)
							socialInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjSum, sjhj),ys).doubleValue());
							//$列表.求总和$($社保订单明细*总数(实缴个人合计)$)+ $实缴个人合计$  - $列表.求总和$($社保订单明细*总数(个人应收)$)
							socialInfo.setFd_3b35a57aee1428(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum, shgr),personYs).doubleValue());
							//列表.求总和$($社保订单明细*总数(实缴单位合计)$)+ $实缴单位合计$  - $列表.求总和$($社保订单明细*总数(单位应收)$)
							socialInfo.setFd_3b35a57b6e9d0a(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum, shdw),dwYs).doubleValue());
						}
					}
				} else {
					if ("预估".equals(socialInfo.getFd_3add9dd7833db8())) {
						//$列表.求总和$($社保订单明细*总数(预估合计)$) + $预估合计$-$列表.求总和$($社保订单明细*总数(应收)$)
						socialInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygSum, yghj),ys).doubleValue());
						//$列表.求总和$( $社保订单明细*总数(预估个人合计)$) + $预估个人合计$-$列表.求总和$($社保订单明细*总数(个人应收)$)
						socialInfo.setFd_3b35a57aee1428(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygPersonSum, yggrhj),personYs).doubleValue());
						//$列表.求总和$($社保订单明细*总数(预估单位合计)$) + $预估单位合计$-$列表.求总和$($社保订单明细*总数(单位应收)$)
						socialInfo.setFd_3b35a57b6e9d0a(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(ygDwSum, ygdwbf),dwYs).doubleValue());
					} else {
						//$列表.求总和$($社保订单明细*总数(实缴合计)$)+ $实缴合计$  - $列表.求总和$($社保订单明细*总数(应收)$)
						socialInfo.setFd_3adfeb7b624f06(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjSum, sjhj),ys).doubleValue());
						//$列表.求总和$($社保订单明细*总数(实缴个人合计)$)+ $实缴个人合计$  - $列表.求总和$($社保订单明细*总数(个人应收)$)
						socialInfo.setFd_3b35a57aee1428(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjPersonSum, shgr),personYs).doubleValue());
						//$列表.求总和$($社保订单明细*总数(实缴单位合计)$)+ $实缴单位合计$  - $列表.求总和$($社保订单明细*总数(单位应收)$)
						socialInfo.setFd_3b35a57b6e9d0a(BigDecimalUtils.safeSubtract(false,BigDecimalUtils.safeAdd(sjDwSum, shdw),dwYs).doubleValue());
					}
				}
			}
			if ("预估".equals(socialInfo.getFd_3add9dd7833db8())) {
				//应支出
				socialInfo.setFd_3adfeb7bd97464(CommonConstants.ZERO_INTEGER.doubleValue());
				//个人应支
				socialInfo.setFd_3b35a5b03100c4(CommonConstants.ZERO_INTEGER.doubleValue());
				//单位应支
				socialInfo.setFd_3b35a5b0b04d54(CommonConstants.ZERO_INTEGER.doubleValue());
			} else {
				//应支出
				socialInfo.setFd_3adfeb7bd97464(socialInfo.getFd_3af9f3059e5b9c());
				//个人应支
				socialInfo.setFd_3b35a5b03100c4(socialInfo.getFd_3af9f303037214());
				//单位应支
				socialInfo.setFd_3b35a5b0b04d54(socialInfo.getFd_3af9f2e9208e4e());
			}
			//创建时间
			socialInfo.setCreateTime(DateUtil.getCurrentDateTime());
			socialInfoList.add(socialInfo);
			//金额累加
			//预估单位合计
			ygDwSum = ygDwSum.add(Common.isEmpty(socialInfo.getFd_3adfeb4e8064a8()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3adfeb4e8064a8()));
			//实缴单位合计
			sjDwSum = sjDwSum.add(Common.isEmpty(socialInfo.getFd_3af9f2e9208e4e()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f2e9208e4e()));
			//实缴个人合计
			sjPersonSum = sjPersonSum.add(Common.isEmpty(socialInfo.getFd_3af9f303037214()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f303037214()));
			//预估合计
			ygSum = ygSum.add(Common.isEmpty(socialInfo.getFd_3af9f2883941b4()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f2883941b4()));
			//预估个人合计
			ygPersonSum = ygPersonSum.add(Common.isEmpty(socialInfo.getFd_3af9f285ee1e38()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f285ee1e38()));
			//实缴合计
			sjSum = sjSum.add(Common.isEmpty(socialInfo.getFd_3af9f3059e5b9c()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3af9f3059e5b9c()));
			//应收
			ys = ys.add(Common.isEmpty(socialInfo.getFd_3adfeb7b624f06()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3adfeb7b624f06()));
			//个人应收
			personYs = personYs.add(Common.isEmpty(socialInfo.getFd_3b35a57aee1428()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3b35a57aee1428()));
			//单位应收
			dwYs = dwYs.add(Common.isEmpty(socialInfo.getFd_3b35a57b6e9d0a()) ? BigDecimal.ZERO : BigDecimal.valueOf(socialInfo.getFd_3b35a57b6e9d0a()));

			if (CommonConstants.ZERO_STRING.equals(socialParam.getYgFlag())) {
				stringBuilder.append(socialParam.getSocialIds()).append(",");
				paymentIds.add(socialParam.getSocialIds());
				TPaymentSocialPush a = new TPaymentSocialPush();
				a.setPaymentIds(socialParam.getSocialIds());
				a.setId(socialParam.getFd_3b0afbe1f94a08());
				socialPushList.add(a);
			} else {
				paymentIds.add(socialParam.getFd_3b0afbe1f94a08());
			}
		}
		if (!socialInfoList.isEmpty()) {
			this.saveBatch(socialInfoList);
		}
	}

	@Override
	public R updateScoialStatus(List<EkpSocialStatusUpdateVo> list) {
		if (Optional.ofNullable(list).isPresent()) {
			for (EkpSocialStatusUpdateVo socialStatusUpdateVo : list) {
				String updateSql = socialStatusUpdateVo.getUpdateSql().replaceAll("\\?","%s");
				String sql = String.format(updateSql, socialStatusUpdateVo.getParam().toArray());
				baseMapper.updateSocialStatus(sql);
			}
			return R.ok();
		}
		return null;
	}

	private void copySocialProperties(EkpPushSocialParam socialParam,EkpSocialInfo socialInfo) {
		//订单类型
		socialInfo.setFd_3add9dd7833db8(socialParam.getFd_3add9dd7833db8());
		//与工资合并结算
		socialInfo.setFd_3add9e1a670144(socialParam.getFd_3add9e1a670144());
		//是否有预估
		socialInfo.setFd_3add9de0be85e4(socialParam.getFd_3add9de0be85e4());
		//是否为BPO业务
		socialInfo.setFd_3b178e3ba5e258(socialParam.getFd_3b178dfcf9e3e6());
		//创建人姓名
		socialInfo.setFd_3b438e61af0a56(socialParam.getFd_3b438e33f37378());
		//项目编码
		socialInfo.setFd_3adfe8c70d3fd4(socialParam.getFd_3adfe8c70d3fd4());
		//项目名称
		socialInfo.setFd_3adfe8c8468e54(socialParam.getFd_3adfe8c8468e54());
		//项目编码-原  fxj 20240527 add
		socialInfo.setFd_3cfe2da7e35daa(socialParam.getFd_3adfe8c70d3fd4());
		//项目名称-原  fxj 20240527 add
		socialInfo.setFd_3cfe2db5015d6e(socialParam.getFd_3adfe8c8468e54());
		//单号
		socialInfo.setFd_3adfe95c169c48(socialParam.getFd_3adfe95c169c48());
		//客户编码
		socialInfo.setFd_3adfe8c73cb5a4(socialParam.getFd_3adfe8c73cb5a4());
		//客户名称
		socialInfo.setFd_3adfe8c81a0e42(socialParam.getFd_3adfe8c81a0e42());
		//社保户
		socialInfo.setFd_3aeafa25916e82(socialParam.getFd_3aeafa25916e82());
		//姓名
		socialInfo.setFd_3adfe8c79989d4(socialParam.getFd_3adfe8c79989d4());
		//身份证号
		socialInfo.setFd_3adfe8c7e4cf7a(socialParam.getFd_3adfe8c7e4cf7a());
		//我司到款单位
		socialInfo.setFd_3b0194c7336de0(socialParam.getFd_3b01953871b8be());
		//生成月份
		socialInfo.setFd_3adfe8cb96c41e(socialParam.getFd_3adfe8cb96c41e());
		//缴纳月份
		socialInfo.setFd_3adfe8cf632700(socialParam.getFd_3adfe8cf632700());
		//社保ID
		socialInfo.setFd_3b0b716e771e06(socialParam.getFd_3b0afbe1f94a08());
		//薪酬申请编号
		socialInfo.setFd_3b3cab5f343a90(socialParam.getFd_3b3cab77923f44());
		//缴纳地
		socialInfo.setFd_3b5cc5e697079a(socialParam.getFd_3b5cc58d1a70fe());
		//社保合集ID
		socialInfo.setFd_3b6495a5ad6e10(socialParam.getSocialIds());
		//预估单位养老
		socialInfo.setFd_3af9f257b1b586(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ec80a9de7a()) ? null : Double.valueOf(socialParam.getFd_3af9ec80a9de7a()));
		//预估单位医疗
		socialInfo.setFd_3af9f25b851e94(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba5899c90()) ? null : Double.valueOf(socialParam.getFd_3af9eba5899c90()));
		//预估单位失业
		socialInfo.setFd_3af9f25f5e9cc4(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba5f6e19e()) ? null : Double.valueOf(socialParam.getFd_3af9eba5f6e19e()));
		//预估单位工伤
		socialInfo.setFd_3af9f2617e530a(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba684f592()) ? null : Double.valueOf(socialParam.getFd_3af9eba684f592()));
		//预估单位生育
		socialInfo.setFd_3af9f263e094c6(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba71c0138()) ? null : Double.valueOf(socialParam.getFd_3af9eba71c0138()));
		//预估单位补缴利息
		socialInfo.setFd_3af9f267a03bd6(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba7c3da5e()) ? null : Double.valueOf(socialParam.getFd_3af9eba7c3da5e()));
		//预估单位大病救助
		socialInfo.setFd_3af9f26a3cae94(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9eba863c0ee()) ? null : Double.valueOf(socialParam.getFd_3af9eba863c0ee()));
		//预估单位合计
		socialInfo.setFd_3adfeb4e8064a8(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb4e8064a8()) ? null : Double.valueOf(socialParam.getFd_3adfeb4e8064a8()));
		//预估个人养老
		socialInfo.setFd_3af9f27a3974e6(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ebbd791662()) ? null : Double.valueOf(socialParam.getFd_3af9ebbd791662()));
		//预估个人医疗
		socialInfo.setFd_3af9f27ce947ac(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ebbdd9797e()) ? null : Double.valueOf(socialParam.getFd_3af9ebbdd9797e()));
		//预估个人失业
		socialInfo.setFd_3af9f27efdd912(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ebbe29ce1c()) ? null : Double.valueOf(socialParam.getFd_3af9ebbe29ce1c()));
		//预估个人补缴利息
		socialInfo.setFd_3af9f281651734(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ebbecc4aa8()) ? null : Double.valueOf(socialParam.getFd_3af9ebbecc4aa8()));
		//预估个人大病救助
		socialInfo.setFd_3af9f283a6f288(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ebbf3e8be2()) ? null : Double.valueOf(socialParam.getFd_3af9ebbf3e8be2()));
		//预估个人合计
		socialInfo.setFd_3af9f285ee1e38(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3adfeb52a4d2e2()) ? null : Double.valueOf(socialParam.getFd_3adfeb52a4d2e2()));
		//预估合计
		socialInfo.setFd_3af9f2883941b4(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ed7e813b86()) ? null : Double.valueOf(socialParam.getFd_3af9ed7e813b86()));
		//实缴单位养老
		socialInfo.setFd_3af9f2d8df88c0(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3938170a()) ? null : Double.valueOf(socialParam.getFd_3af9ee3938170a()));
		//实缴单位医疗
		socialInfo.setFd_3af9f2db1e5e16(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee39dea6a8()) ? null : Double.valueOf(socialParam.getFd_3af9ee39dea6a8()));
		//实缴单位失业
		socialInfo.setFd_3af9f2dd5d8fb8(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3a46b7e6()) ? null : Double.valueOf(socialParam.getFd_3af9ee3a46b7e6()));
		//实缴单位工伤
		socialInfo.setFd_3af9f2e03295dc(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3aa9c84a()) ? null : Double.valueOf(socialParam.getFd_3af9ee3aa9c84a()));
		//实缴单位生育
		socialInfo.setFd_3af9f2e237f794(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3afb34c2()) ? null : Double.valueOf(socialParam.getFd_3af9ee3afb34c2()));
		//实缴单位补缴利息
		socialInfo.setFd_3af9f2e45a5d78(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3b5ddae8()) ? null : Double.valueOf(socialParam.getFd_3af9ee3b5ddae8()));
		//实缴单位合计
		socialInfo.setFd_3af9f2e9208e4e(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3c0bf286()) ? null : Double.valueOf(socialParam.getFd_3af9ee3c0bf286()));
		//实缴个人养老
		socialInfo.setFd_3af9f2ec516c30(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3e513962()) ? null : Double.valueOf(socialParam.getFd_3af9ee3e513962()));
		//实缴个人医疗
		socialInfo.setFd_3af9f2f8290f24(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3e066d48()) ? null : Double.valueOf(socialParam.getFd_3af9ee3e066d48()));
		//实缴个人失业
		socialInfo.setFd_3af9f2fa79ee72(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3db44d96()) ? null : Double.valueOf(socialParam.getFd_3af9ee3db44d96()));
		//实缴个人补缴利息
		socialInfo.setFd_3af9f2fcde9158(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3d634946()) ? null : Double.valueOf(socialParam.getFd_3af9ee3d634946()));
		//实缴个人大病救助
		socialInfo.setFd_3af9f2ff2c9f42(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3d0ba3b6()) ? null : Double.valueOf(socialParam.getFd_3af9ee3d0ba3b6()));
		//实缴单位大病救助
		socialInfo.setFd_3af9f2e6dfb3f4(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3ba76f54()) ? null : Double.valueOf(socialParam.getFd_3af9ee3ba76f54()));
		//实缴个人合计
		socialInfo.setFd_3af9f303037214(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3cb6d4fa()) ? null : Double.valueOf(socialParam.getFd_3af9ee3cb6d4fa()));
		//实缴合计
		socialInfo.setFd_3af9f3059e5b9c(CommonConstants.EMPTY_STRING.equals(socialParam.getFd_3af9ee3c6bfc74()) ? null : Double.valueOf(socialParam.getFd_3af9ee3c6bfc74()));
		//结算状态
		socialInfo.setFd_3add9ea428879a(socialParam.getFd_3add9ea428879a());
		//收款状态
		socialInfo.setFd_3add9eaeed2560("未收");
		//支出结算状态
		socialInfo.setFd_3add9edfbc6f7e("未结算");
		//付款状态
		socialInfo.setFd_3add9eed23894a("未付");
		//单号
		socialInfo.setFd_3adfe95c169c48("SB" + LocalDateTimeUtils.formatTime(LocalDateTime.now(),DateUtil.DATE_PATTERN)
				+ "_" + socialParam.getFd_3b0afbe1f94a08());
	}


	/**
	 * @Description: 推送ekp时更改日期格式
	 * @Author: huyc
	 **/
	public String dateStringInsert(String month) {
		StringBuilder sb = new StringBuilder(month);
		sb.insert(4, "-");
		return sb.toString();
	}

}
