/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 社保士兵实缴核验错误反馈表
 *
 * @author hgw
 * @date 2024-06-06 20:55:31
 */
@Data
@TableName("t_auto_payment_error")
@Schema(description = "社保士兵实缴核验错误反馈表")
public class TAutoPaymentError {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	@ExcelIgnore
	private String id;
	/**
	 * 主表ID
	 */
	@ExcelAttribute(name = "主表ID", isNotEmpty = true, errorInfo = "主表ID不能为空", maxLength = 32)
	@NotBlank(message = "主表ID不能为空")
	@Length(max = 32, message = "主表ID不能超过32个字符")
	@ExcelProperty("主表ID")
	@Schema(description = "主表ID")
	@ExcelIgnore
	private String parentId;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "姓名不能超过32个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 证件号码
	 */
	@ExcelAttribute(name = "证件号码", maxLength = 50)
	@Length(max = 50, message = "证件号码不能超过50个字符")
	@ExcelProperty("证件号码")
	@Schema(description = "证件号码")
	private String certNum;
	/**
	 * 险种
	 */
	@ExcelAttribute(name = "险种", maxLength = 50)
	@Length(max = 50, message = "险种不能超过50个字符")
	@ExcelProperty("险种")
	@Schema(description = "险种")
	private String insuranceType;
	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户", maxLength = 100)
	@Length(max = 100, message = "社保户不能超过100个字符")
	@ExcelProperty("社保户")
	@Schema(description = "社保户")
	private String socialSecurityAccount;
	/**
	 * 错误信息
	 */
	@ExcelAttribute(name = "错误信息", maxLength = 50)
	@Length(max = 50, message = "错误信息不能超过50个字符")
	@ExcelProperty("错误信息")
	@Schema(description = "错误信息")
	private String errorInfo;

}
