/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SocialAndFundReduceVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.entity.TSocialFundInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.shardingsphere.transaction.annotation.ShardingTransactionType;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TDispatchInfoService extends IService<TDispatchInfo> {
	/**
	 * 派单信息记录表简单分页查询
	 * @param tDispatchInfo 派单信息记录表
	 * @return
	 */
	IPage<TDispatchInfoPageVo> getTDispatchInfoPage(Page<TDispatchInfo> page, TDispatchInfoSearchVo tDispatchInfo);

	IPage<TDispatchInfoPageVo> getTDispatchInfoPageAudit(Page<TDispatchInfo> page, TDispatchInfoSearchVo tDispatchInfo);

	R<List<ErrorMessage>> importDiy(InputStream inputStream, String orderId);

	R<List<ErrorMessage>> importSocialHandler(InputStream inputStream,String mId, boolean isAutoHandle);

	void listExport(HttpServletResponse response, TDispatchInfoSearchVo searchVo);

	void listAuditExport(HttpServletResponse response, TDispatchInfoSearchVo searchVo);

	List<TDispatchInfo> noPageDiy(TDispatchInfoSearchVo searchVo);

	@Transactional
	@ShardingTransactionType(TransactionType.BASE)
	void importTDispatchInfo(List<TDispatchImportVo> excelVOList,
							 List<ErrorMessage> errorMessageList,
							 YifuUser user, String orderId, Map<String, String> idCardMap);

	R<List<ErrorMessage>> importReduceDiy(InputStream inputStream, String orderId,String flag);

	@Transactional
	@ShardingTransactionType(TransactionType.BASE)
	void batchReduceDispatch(List<TDispatchReduceVo> excelVOList, List<ErrorMessage> errorMessageList, YifuUser user, String orderId,String flag);

	R<Boolean> removeByIdDiy(String id);

	DispatchDetailVo getSocialAndFundInfoById(String id);

	List<ErrorMessage> addBatchApplyAudit(List<String> idsList, YifuUser user, int flag, String auditStatus
			, String auditRemark, String remark, String isSingleAudit);

	R<List<ErrorMessage>>  addApplyAudit(List<String> ids, String auditStatus, String auditRemark, String remark
			, String isSingleAudit);

	// isAutoFlag:是否社保士兵的自动办理，true :是
	R<List<ErrorMessage>>  addApplyHandle(List<String> ids, String typeSub, String handleStatus, String handleRemark, String socialType, String remark, YifuUser user, boolean isAutoHandle);

    //代码优化-解决死锁问题：fxj 2024-12-18 事务控制集中到每次循环，而不是所有for循环
    boolean extracted(ConcurrentHashMap<String, String> socialMap, ConcurrentHashMap<String, String> fundMap, String typeSub, YifuUser user, int flag, String handleStatus, String handleRemark, String socialType, String remark, boolean isAutoHandle, List<ErrorMessage> errorList, Map<String, TSocialFundInfo> socialFundMap, TDispatchInfo dis);

    /**
	 * @Description: 社保士兵导出
	 * @Author: hgw
	 * @Date: 2024/5/13 11:34
	 * @return: void
	 **/
	void doExportSocialSoldier(HttpServletResponse response, SocialHandleSearchVo searchVo, String idStr, String[] exportFields);
	/**
	 * @Description: 自动化办理查询导出
	 * @Author: hgw
	 * @Date: 2025/4/25 18:28
	 * @return: void
	 **/
	void doExportSocialSoldierAll(HttpServletResponse response, SocialHandleSearchVo searchVo, String idStr, String[] exportFields);
	void doexportSocialRecordRoster(HttpServletResponse response, SocialHandleSearchVo searchVo, String idStr, String[] exportFields);

	/**
	 * @Description: 社保士兵办理列表查询
	 * @Author: hgw
	 * @Date: 2024/5/10 11:51
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo>
	 **/
	IPage<TSocialSoldierPageVo> getTSocialSoldierHandlePage(Page<TSocialSoldierPageVo> page, SocialHandleSearchVo tDispatchInfo);

	/**
	 * @param page
	 * @param tDispatchInfo
	 * @Description: 社保士兵查询列表——按派单维度
	 * @Author: hgw
	 * @Date: 2025/4/25 18:07
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.plus.v1.yifu.social.vo.TSocialSoldierPageVo>
	 **/
	IPage<TSocialSoldierPageVo> getPageSocialSoldierAll(Page<TSocialSoldierPageVo> page, SocialHandleSearchVo tDispatchInfo);

	IPage<TDispatchInfo> getTDispatchSocialHandlePage(Page<TDispatchInfo> page, SocialHandleSearchVo tDispatchInfo);

	IPage<TDispatchInfo> getTDispatchFundHandlePage(Page<TDispatchInfo> page, SocialHandleSearchVo tDispatchInfo);

	R<List<FundSupplementaryExportVo>> getFundSupplementaryRecords(String idStr,SocialHandleSearchVo dispatchInfo, List<String> settleDomains, String sql);

	void doexportFundRecordChange(HttpServletResponse response,String idStr, SocialHandleSearchVo searchVo);

	void doexportSocialRecordNew(HttpServletResponse response, SocialHandleSearchVo searchVo);

	void doexportSocialPensionRecord(HttpServletResponse response, SocialHandleSearchVo searchVo);

	/**
	 * 获取社保和公积金派减日期
	 * @Author hgw
	 * @Date 2023-1-5 11:00:47
	 * @param empId
	 * @return
	 **/
	SocialAndFundReduceVo getSocialAndFundReduceInfo(String empId);

	/**
	 * @param importVo
	 * @Description: 单个派增
	 * @Author: hgw
	 * @Date: 2023/3/10 15:46
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> dispatchAdd(TDispatchImportVo importVo);

	R<List<ErrorMessage>> fundImportHandle(InputStream inputStream,TDispatchInfo tDispatchInfo, boolean isAutoFlag);

	R<Boolean> updateExportSocialFlagById(String id,String status);

	R<Boolean> updateExportFundFlagById(String id,String status);

	/**
	 * @param user
	 * @param roleId  SSC派单组-1659015946137583618L  SSC审核组-1659016108176130049L
	 * @Description: 判断用户是否含有某个角色
	 * @Author: hgw
	 * @Date: 2023/5/18 16:15
	 * @return: boolean
	 **/
	boolean haveRole(YifuUser user, long roleId);

	void doexportFundInfo(HttpServletResponse response, SocialHandleSearchVo searchVo);

	void doexportFundInfoOne(HttpServletResponse response, SocialHandleSearchVo searchVo);

	/**
	 * @param searchVo
	 * @param idStr
	 * @Description: 导出社保花名册
	 * @Author: hgw
	 * @Date: 2024/5/8 19:18
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.SocialHandleExportVo>
	 **/
	List<SocialHandleExportVo> getRecordRosterList(SocialHandleSearchVo searchVo, String idStr);

	R<URL> doExportRoster(String socialId, String type,String unitCreditCode);
}
