/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 收入证明 中的 单位信息维护表
 *
 * @author fxj
 * @date 2023-08-23 17:31:05
 */
@Data
public class TCompanyInfoVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@ExcelProperty("id")
	private String id;
	/**
	 * 公司名称
	 */
	@NotBlank(message = "公司名称 不能为空")
	@Length(max = 50, message = "公司名称 不能超过50 个字符")
	@ExcelAttribute(name = "公司名称", isNotEmpty = true, errorInfo = "公司名称 不能为空", maxLength = 50)
	@Schema(description = "公司名称")
	@ExcelProperty("公司名称")
	private String 公司名称;
	/**
	 * 公司地址
	 */
	@NotBlank(message = "公司地址 不能为空")
	@Length(max = 200, message = "公司地址 不能超过200 个字符")
	@ExcelAttribute(name = "公司地址", isNotEmpty = true, errorInfo = "公司地址 不能为空", maxLength = 200)
	@Schema(description = "公司地址")
	@ExcelProperty("公司地址")
	private String companyAddress;
	/**
	 * 公司电话
	 */
	@NotBlank(message = "公司电话 不能为空")
	@Length(max = 20, message = "公司电话 不能超过20 个字符")
	@ExcelAttribute(name = "公司电话", isNotEmpty = true, errorInfo = "公司电话 不能为空", maxLength = 20)
	@Schema(description = "公司电话")
	@ExcelProperty("公司电话")
	private String companyTel;
	/**
	 * 创建人id
	 */
	@NotBlank(message = "创建人id 不能为空")
	@Length(max = 32, message = "创建人id 不能超过32 个字符")
	@ExcelAttribute(name = "创建人id", isNotEmpty = true, errorInfo = "创建人id 不能为空", maxLength = 32)
	@Schema(description = "创建人id")
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 32, message = "创建人姓名 不能超过32 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@NotBlank(message = "创建时间 不能为空")
	@ExcelAttribute(name = "创建时间", isNotEmpty = true, errorInfo = "创建时间 不能为空", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private Date createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 32, message = "更新人id 不能超过32 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 32)
	@Schema(description = "更新人id")
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private Date updateTime;
	/**
	 * 0 未删除 1 已删除
	 */
	@Length(max = 1, message = "0 未删除 1 已删除 不能超过1 个字符")
	@ExcelAttribute(name = "0 未删除 1 已删除", maxLength = 1)
	@Schema(description = "0 未删除 1 已删除")
	@ExcelProperty("0 未删除 1 已删除")
	private String deleteFlag;

}
