package com.yifu.cloud.plus.v1.business.query.salary;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * 个人薪酬统计分页查询参数
 *
 * @author: wangweiguo
 * @date: 2021/9/8
 */
@Getter
@Setter
@ToString
public class TSalaryStatisticsPersonalPageQuery extends TSalaryStatisticsPersonalQuery{

    /**
     * 当前页码 默认为1
     */
    @Schema(description ="当前页码 默认为1")
    private long current = 1;

    /**
     * 每页数量 默认为10
     */
    @Schema(description ="每页数量 默认为10")
    private long size = 10;

    /**
     * 排序字段
     */
    @Schema(description ="排序字段")
    private List<OrderItem> orders;

}
