package com.yifu.cloud.plus.v1.permission.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysUserRoleResService;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.HcmInitRoleInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserRoleRes;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserRoleResSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 新权限-账号-角色关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysuserroleres")
@Tag(name = "新权限-账号-角色关联表管理")
public class SysUserRoleResController {

	private final SysUserRoleResService sysUserRoleResService;


	/**
	 * 简单分页查询
	 *
	 * @param page           分页对象
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysUserRoleRes>> getSysUserRoleResPage(Page<SysUserRoleRes> page, SysUserRoleResSearchVo sysUserRoleRes) {
		return new R<>(sysUserRoleResService.getSysUserRoleResPage(page, sysUserRoleRes));
	}

	/**
	 * 不分页查询
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<SysUserRoleRes>> getSysUserRoleResNoPage(@RequestBody SysUserRoleResSearchVo sysUserRoleRes) {
		return R.ok(sysUserRoleResService.noPageDiy(sysUserRoleRes));
	}

	/**
	 * 根据角色id获取被使用的账号名称
	 * @return
	 */
	@Operation(summary = "根据角色id获取被使用的账号名称", description = "根据角色id获取被使用的账号名称")
	@GetMapping("/getSysUserByRoleId")
	public R<List<String>> getSysUserByRoleId(@RequestParam String roleId) {
		return R.ok(sysUserRoleResService.getSysUserByRoleId(roleId));
	}

	/**
	 * 通过id查询新权限-账号-角色关联表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('ekp_sysuserroleres_get')")
	@GetMapping("/{fdId}")
	@PreAuthorize("@pms.hasPermission('ekp_sysuserroleres_get')")
	public R<SysUserRoleRes> getById(@PathVariable("fdId") String fdId) {
		return R.ok(sysUserRoleResService.getById(fdId));
	}

	/**
	 * 新增新权限-账号-角色关联表
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return R
	 */
	@Operation(summary = "新增新权限-账号-角色关联表", description = "新增新权限-账号-角色关联表：hasPermission('ekp_sysuserroleres_add')")
	@SysLog("新增新权限-账号-角色关联表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysuserroleres_add')")
	public R<Boolean> save(@RequestBody SysUserRoleRes sysUserRoleRes) {
		return R.ok(sysUserRoleResService.save(sysUserRoleRes));
	}

	/**
	 * 修改新权限-账号-角色关联表
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return R
	 */
	@Operation(summary = "修改新权限-账号-角色关联表", description = "修改新权限-账号-角色关联表：hasPermission('ekp_sysuserroleres_edit')")
	@SysLog("修改新权限-账号-角色关联表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysuserroleres_edit')")
	public R<Boolean> updateById(@RequestBody SysUserRoleRes sysUserRoleRes) {
		return R.ok(sysUserRoleResService.updateById(sysUserRoleRes));
	}

	/**
	 * 通过id删除新权限-账号-角色关联表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id删除新权限-账号-角色关联表", description = "通过id删除新权限-账号-角色关联表：hasPermission('ekp_sysuserroleres_del')")
	@SysLog("通过id删除新权限-账号-角色关联表")
	@DeleteMapping("/{fdId}")
	@PreAuthorize("@pms.hasPermission('ekp_sysuserroleres_del')")
	public R<Boolean> removeById(@PathVariable String fdId) {
		return R.ok(sysUserRoleResService.removeById(fdId));
	}


	/**
	 * @param vo
	 * @Description: 新增用户角色信息
	 * @Author: huyc
	 * @Date: 2024/2/18
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/saveSysUserRole")
	public void saveSysUserRole(@RequestBody HcmInitRoleInfoVo vo) {
		sysUserRoleResService.saveSysUserRole(vo);
	}
}
