/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 社保工资申报、调整推送的记录表
 *
 * @author hgw
 * @date 2024-5-30 09:53:57
 */
@Data
@TableName("t_social_soldier_shen_bao_task")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "社保工资申报、调整推送记录表")
public class TSocialSoldierShenBaoTask extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 推送的任务ID
	 */
	@ExcelAttribute(name = "推送的任务ID", isNotEmpty = true, errorInfo = "推送的任务ID不能为空", maxLength = 32)
	@NotBlank(message = "推送的任务ID不能为空")
	@Length(max = 32, message = "推送的任务ID不能超过32个字符")
	@ExcelProperty("推送的任务ID")
	@Schema(description = "推送的任务ID")
	private String addId;
	/**
	 * 1申报；2调整
	 */
	@ExcelAttribute(name = "1申报；2调整", isNotEmpty = true, errorInfo = "1申报；2调整", maxLength = 2)
	@NotBlank(message = "1申报；2调整不能为空")
	@Length(max = 2, message = "1申报；2调整不能超过1个字符")
	@ExcelProperty("1申报；2调整")
	@Schema(description = "1申报；2调整；3：实缴1日常申报导出；4：实缴2人员缴费明细打印；5：实缴3单位缴费明细查询；6：实缴3单位缴费明细下载")
	private String type;
	/**
	 * 拉取状态：0未拉取；1已拉取
	 */
	@ExcelAttribute(name = "拉取状态：0未拉取；1已拉取", maxLength = 1)
	@Length(max = 1, message = "拉取状态：0未拉取；1已拉取不能超过1个字符")
	@ExcelProperty("拉取状态：0未拉取；1已拉取")
	@Schema(description = "拉取状态：0未拉取；1已拉取")
	private String dataStatus;

}
