package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.social.util.BigDecimalConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName TPaymentHeFeiVo
 * @Description 合肥三险导入  养老 工伤 失业 生育
 * @author huyc
 * @date 2022-07-26 17:01:22
 */
@Data
public class TPaymentHeFeiVo extends RowIndex implements Serializable {
    /**
     * 员工姓名
     */
    @Length(max = 20, message = "员工姓名不能超过20个字符")
    @ExcelAttribute(name = "员工姓名", maxLength = 20,isNotEmpty = true)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
    private String empName;
    /**
     * 员工编码
     */
    @Length(max = 32, message = "员工编码不能超过32个字符")
    @ExcelAttribute(name = "员工编码",  maxLength = 32)
	@Schema(description = "员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工编码")
    private String empNo;
    /**
     * 员工ID
     */
    @Length(max = 32, message = "员工ID不能超过32个字符")
    @ExcelAttribute(name = "员工ID", maxLength = 32)
	@Schema(description = "员工ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工ID")
    private String empId;
    /**
     * 员工身份证
     */
    @Length(max = 100, message = "不能超过100个字符")
    @ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 100,errorInfo = "身份证字段不可为空！")
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
    private String empIdcard;
    /**
     * 社保编号
     */
    @Length(max = 20, message = "社保编号不能超过20个字符")
    @ExcelAttribute(name = "社保编号", maxLength = 20)
	@Schema(description = "社保编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保编号")
    private String socialSecurityNo;
    /**
     * 社保缴纳地
     */
    @Length(max = 50, message = "社保缴纳地不能超过50个字符")
    @ExcelAttribute(name = "社保缴纳地", isNotEmpty = true, errorInfo = "社保缴纳地不可为空", maxLength = 50)
	@Schema(description = "社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地")
    private String socialPayAddr;

    /**
     * 社保缴纳地-省
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-省",  maxLength = 32, isDataId = true, isArea = true, parentField = "")
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-省")
    private Integer socialProvince;
    /**
     * 社保缴纳地-市
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-市",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialProvince")
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-市")
    private Integer socialCity;
    /**
     * 社保缴纳地-县
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保缴纳地-县",  maxLength = 32, isDataId = true, isArea = true, parentField = "socialCity")
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-县")
    private Integer socialTown;
    /**
     * 社保缴纳月份
     */
    @ExcelAttribute(name = "社保缴纳月份", isNotEmpty = true, errorInfo = "社保缴纳月份不可为空", maxLength = 6, min = 6, isInteger = true)
	@Schema(description = "社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳月份")
    private String socialPayMonth;
    /**
     * 社保生成月份
     */
    @Length(max = 6, message = "社保生成月份不能超过6个字符")
    @ExcelAttribute(name = "社保生成月份", isNotEmpty = true, errorInfo = "社保生成月份不可为空",  maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保生成月份")
    private String socialCreateMonth;

    /**
     * 参保险种: 养老保险，失业保险， 工伤保险
     */
    @ExcelAttribute(name = "参保险种")
	@Schema(description = "参保险种")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "参保险种")
    private String riskType;
    /**
     * 个人缴费基数
     */
    @ExcelAttribute(name = "个人缴费基数", isFloat = true,max = "999999999.99")
	@Schema(description = "个人缴费基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人缴费基数", converter = BigDecimalConverter.class)
	private BigDecimal personalSet;
    /**
     * 单位缴费基数
     */
    @ExcelAttribute(name = "单位缴费基数", isFloat = true,max = "999999999.99")
	@Schema(description = "单位缴费基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位缴费基数", converter = BigDecimalConverter.class)
	private BigDecimal unitSet;

    /**
     * 个人缴费额
     */
    @ExcelAttribute(name = "个人缴费额", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "个人缴费额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人缴费额", converter = BigDecimalConverter.class)
	private BigDecimal personalMoney;
    /**
     * 单位缴费额
     */
    @ExcelAttribute(name = "单位缴费额", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "单位缴费额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位缴费额", converter = BigDecimalConverter.class)
	private BigDecimal unitMoney;

    /**
     * 医保基数
     */
    @ExcelAttribute(name = "医保基数", isFloat = true,max = "999999999.99")
	@Schema(description = "医保基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保基数", converter = BigDecimalConverter.class)
	private BigDecimal medicalSet;
    /**
     * 医保单位缴费
     */
    @ExcelAttribute(name = "医保单位缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "医保单位缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保单位缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitMedicalMoney;
    /**
     * 医保个人缴费
     */
    @ExcelAttribute(name = "医保个人缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "医保个人缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保个人缴费", converter = BigDecimalConverter.class)
	private BigDecimal personalMedicalMoney;

    /**
     * 单位医疗救助金 (对应单位大病)
     */
    @ExcelAttribute(name = "单位医疗救助金", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "单位医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位医疗救助金", converter = BigDecimalConverter.class)
	private BigDecimal unitBigailmentMoney;

    /**
     * 个人医疗救助金 (对应个人大病)
     */
    @ExcelAttribute(name = "个人医疗救助金", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description = "个人医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人医疗救助金", converter = BigDecimalConverter.class)
	private BigDecimal personalBigailmentMoney;

    /**
     *  社保ID
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "社保ID", maxLength = 32, isDataId = true)
	@Schema(description = "社保ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保ID")
    private String socialId;

    /**
     *  公积金ID
     */
    @Length(max = 32, message = "不能超过32个字符")
    @ExcelAttribute(name = "公积金ID", maxLength = 32, isDataId = true)
	@Schema(description = "公积金ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金ID")
    private String fundId;
}
